/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.session;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.appformer.client.stateControl.registry.Registry;
import org.appformer.client.stateControl.registry.RegistryChangeListener;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.client.session.CommandRegistryHolder;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;

@ApplicationScoped
public class RegistryProvider {
    private final ManagedInstance<CommandRegistryHolder> registryHolders;
    private final GraphsProvider graphsProvider;
    private final Map<String, Registry<Command<AbstractCanvasHandler, CanvasViolation>>> registryMap;
    private RegistryChangeListener registryChangeListener;

    @Inject
    public RegistryProvider(ManagedInstance<CommandRegistryHolder> registryHolders, GraphsProvider graphsProvider) {
        this.registryHolders = registryHolders;
        this.graphsProvider = graphsProvider;
        this.registryMap = new HashMap<String, Registry<Command<AbstractCanvasHandler, CanvasViolation>>>();
    }

    public Registry<Command<AbstractCanvasHandler, CanvasViolation>> getCurrentCommandRegistry() {
        if (!this.getRegistryMap().containsKey(this.graphsProvider.getCurrentDiagramId())) {
            this.initializeRegistry(this.graphsProvider.getCurrentDiagramId());
        }
        return this.getRegistryMap().get(this.graphsProvider.getCurrentDiagramId());
    }

    public void setRegistryChangeListener(RegistryChangeListener registryChangeListener) {
        this.registryChangeListener = registryChangeListener;
    }

    Map<String, Registry<Command<AbstractCanvasHandler, CanvasViolation>>> getRegistryMap() {
        return this.registryMap;
    }

    Registry<Command<AbstractCanvasHandler, CanvasViolation>> createRegistry() {
        Registry<Command<AbstractCanvasHandler, CanvasViolation>> commandRegistry = ((CommandRegistryHolder)this.registryHolders.get()).getRegistry();
        if (!Objects.isNull(this.registryChangeListener)) {
            commandRegistry.setRegistryChangeListener(this.registryChangeListener);
        }
        return commandRegistry;
    }

    void initializeRegistry(String diagramId) {
        this.getRegistryMap().putIfAbsent(diagramId, this.createRegistry());
    }
}

