/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.codecompletion;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.NamedElement;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

@ApplicationScoped
public class MonacoFEELVariableSuggestions {
    private final DMNGraphUtils dmnGraphUtils;

    @Inject
    public MonacoFEELVariableSuggestions(DMNGraphUtils dmnGraphUtils) {
        this.dmnGraphUtils = dmnGraphUtils;
    }

    public List<String> getSuggestions() {
        List<Object> diagramDefinitions = this.getDiagramDefinitions();
        List<String> dataTypesSuggestions = this.getDataTypesSuggestions(diagramDefinitions);
        List<String> namedElementSuggestions = this.getNamedElementSuggestions(diagramDefinitions);
        return Stream.of(dataTypesSuggestions, namedElementSuggestions).flatMap(Collection::stream).distinct().filter(name -> !name.isEmpty()).sorted().collect(Collectors.toList());
    }

    private List<String> getNamedElementSuggestions(List<Object> diagramDefinitions) {
        return diagramDefinitions.stream().map(this::getNamedSuggestion).collect(Collectors.toList());
    }

    private List<String> getDataTypesSuggestions(List<Object> diagramDefinitions) {
        return diagramDefinitions.stream().flatMap(this::getDataTypesSuggestions).collect(Collectors.toList());
    }

    private String getNamedSuggestion(Object definition) {
        if (definition instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)definition;
            return this.getName(namedElement);
        }
        return "";
    }

    private Stream<? extends String> getDataTypesSuggestions(Object definition) {
        if (definition instanceof DMNDiagram) {
            DMNDiagram dmnDiagram = (DMNDiagram)definition;
            return dmnDiagram.getDefinitions().getItemDefinition().stream().map(this::getName);
        }
        return Stream.empty();
    }

    private List<Object> getDiagramDefinitions() {
        return this.dmnGraphUtils.getNodeStream().map(Element::getContent).filter(c -> c instanceof Definition).map(c -> (Definition)c).map(Definition::getDefinition).collect(Collectors.toList());
    }

    private String getName(NamedElement namedElement) {
        Name name = namedElement.getName();
        return name.getValue();
    }
}

