/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.shape.Group;
import com.google.gwt.core.client.GWT;
import java.util.List;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;

public class EditableHeaderUtilities {
    public static boolean hasEditableHeader(GridColumn<?> column) {
        return column.getHeaderMetaData().stream().anyMatch(md -> md instanceof EditableHeaderMetaData);
    }

    public static boolean isEditableHeader(GridColumn<?> column, Integer uiHeaderRowIndex) {
        return column.getHeaderMetaData().get(uiHeaderRowIndex) instanceof EditableHeaderMetaData;
    }

    public static boolean isPlaceHolderToBeShown(EditableHeaderMetaData headerMetaData) {
        return StringUtils.isEmpty((String)headerMetaData.getTitle()) && headerMetaData.getPlaceHolder().isPresent();
    }

    public static Group getEditableHeaderContent(Supplier<Group> defaultHeaderContentSupplier, List<GridColumn.HeaderMetaData> headerMetaData, GridHeaderColumnRenderContext context, int headerRowIndex, double blockWidth, double rowHeight) {
        Group headerGroup = (Group)GWT.create(Group.class);
        if (headerRowIndex >= headerMetaData.size()) {
            return headerGroup;
        }
        GridColumn.HeaderMetaData headerRowMetaData = headerMetaData.get(headerRowIndex);
        if (headerRowMetaData instanceof EditableHeaderMetaData) {
            EditableHeaderMetaData editableHeaderMetaData = (EditableHeaderMetaData)headerRowMetaData;
            if (EditableHeaderUtilities.isPlaceHolderToBeShown(editableHeaderMetaData)) {
                return editableHeaderMetaData.renderPlaceHolder(context, blockWidth, rowHeight);
            }
            return ((EditableHeaderMetaData)headerRowMetaData).render(context, blockWidth, rowHeight);
        }
        return defaultHeaderContentSupplier.get();
    }
}

