/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.dom;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.Element;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoPropertiesFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.dom.MonacoEditorWidget;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.views.pfly.monaco.MonacoEditorInitializer;
import org.uberfire.client.views.pfly.monaco.jsinterop.Monaco;
import org.uberfire.client.views.pfly.monaco.jsinterop.MonacoStandaloneCodeEditor;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.impl.BaseDOMElement;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public class MonacoEditorDOMElement
extends BaseDOMElement<String, MonacoEditorWidget>
implements TakesValue<String>,
Focusable {
    private final SessionManager sessionManager;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final Function<GridCellTuple, Command> hasNoValueCommand;
    private final Function<GridCellValueTuple, Command> hasValueCommand;
    private String originalValue;

    public MonacoEditorDOMElement(MonacoEditorWidget widget, GridLayer gridLayer, GridWidget gridWidget, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Function<GridCellTuple, Command> hasNoValueCommand, Function<GridCellValueTuple, Command> hasValueCommand) {
        super((Widget)widget, gridLayer, gridWidget);
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.hasNoValueCommand = hasNoValueCommand;
        this.hasValueCommand = hasValueCommand;
    }

    public void setupElements() {
        this.setupContainerComponent();
        this.setupInternalComponent();
    }

    void setupContainerComponent() {
        SimplePanel container = this.getContainer();
        Style style = container.getElement().getStyle();
        style.setPadding(5.0, Style.Unit.PX);
        container.setWidget(this.widget);
    }

    void setupInternalComponent() {
        Style style = ((MonacoEditorWidget)this.widget).getElement().getStyle();
        style.setWidth(100.0, Style.Unit.PCT);
        style.setHeight(100.0, Style.Unit.PCT);
        this.makeMonacoEditorInitializer().require(this.onMonacoLoaded(), new String[0]);
    }

    Consumer<Monaco> onMonacoLoaded() {
        MonacoPropertiesFactory properties = this.makeMonacoPropertiesFactory();
        return monaco -> {
            MonacoStandaloneCodeEditor codeEditor = monaco.editor.create(this.uncheckedCast(((MonacoEditorWidget)this.widget).getElement()), properties.getConstructionOptions());
            codeEditor.onKeyDown(this.getOnKeyDown(codeEditor));
            codeEditor.onDidBlurEditorWidget(this.getWidgetTrigger(this.getBlurEvent()));
            ((MonacoEditorWidget)this.widget).setCodeEditor(codeEditor);
            ((MonacoEditorWidget)this.widget).setFocus(true);
        };
    }

    MonacoStandaloneCodeEditor.CallbackFunction getOnKeyDown(MonacoStandaloneCodeEditor codeEditor) {
        return event -> {
            boolean isEsc;
            boolean isSuggestWidgetVisible = codeEditor.isSuggestWidgetVisible();
            boolean bl = isEsc = event.getKeyCode() == 9;
            if (isSuggestWidgetVisible && isEsc) {
                codeEditor.trigger("keyboard", "cursorHome");
                codeEditor.trigger("keyboard", "cursorEnd");
                event.stopPropagation();
                event.preventDefault();
            }
        };
    }

    public void initialise(GridBodyCellRenderContext context) {
        this.transform(context);
    }

    public void setValue(String value) {
        ((MonacoEditorWidget)this.getWidget()).setValue(value);
        this.originalValue = value;
    }

    public String getValue() {
        return ((MonacoEditorWidget)this.getWidget()).getValue();
    }

    public int getTabIndex() {
        return ((MonacoEditorWidget)this.getWidget()).getTabIndex();
    }

    public void setAccessKey(char key) {
        ((MonacoEditorWidget)this.getWidget()).setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        ((MonacoEditorWidget)this.getWidget()).setFocus(focused);
    }

    public void setTabIndex(int index) {
        ((MonacoEditorWidget)this.getWidget()).setTabIndex(index);
    }

    public void flush(String value) {
        ((MonacoEditorWidget)this.widget).getCodeEditor().ifPresent(c -> c.dispose());
        if (Objects.equals(value, this.originalValue)) {
            return;
        }
        int rowIndex = this.context.getRowIndex();
        int columnIndex = this.context.getColumnIndex();
        if (StringUtils.isEmpty((String)value)) {
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), this.hasNoValueCommand.apply(new GridCellTuple(rowIndex, columnIndex, this.gridWidget)));
        } else {
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), this.hasValueCommand.apply(new GridCellValueTuple<BaseGridCellValue>(rowIndex, columnIndex, this.gridWidget, new BaseGridCellValue((Object)value))));
        }
    }

    MonacoStandaloneCodeEditor.CallbackFunction getWidgetTrigger(NativeEvent nativeEvent) {
        return e -> this.fireNativeEvent(nativeEvent, (HasHandlers)this.widget);
    }

    void fireNativeEvent(NativeEvent nativeEvent, HasHandlers handlerSource) {
        DomEvent.fireNativeEvent((NativeEvent)nativeEvent, (HasHandlers)handlerSource);
    }

    NativeEvent getBlurEvent() {
        return Document.get().createBlurEvent();
    }

    Element uncheckedCast(com.google.gwt.user.client.Element element) {
        return (Element)Js.uncheckedCast((Object)element);
    }

    MonacoPropertiesFactory makeMonacoPropertiesFactory() {
        return new MonacoPropertiesFactory();
    }

    MonacoEditorInitializer makeMonacoEditorInitializer() {
        return new MonacoEditorInitializer();
    }
}

