/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.panel;

import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.DomEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.dmn.client.editors.expressions.util.DynamicReadOnlyUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelCellSelectionHandler;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.mvp.Command;

public class DMNGridPanelContextMenuHandler
implements ContextMenuHandler {
    private DMNGridLayer gridLayer;
    private CellEditorControlsView.Presenter cellEditorControls;
    private DMNGridPanelCellSelectionHandler cellSelectionHandler;

    DMNGridPanelContextMenuHandler(DMNGridLayer gridLayer, CellEditorControlsView.Presenter cellEditorControls, DMNGridPanelCellSelectionHandler cellSelectionHandler) {
        this.gridLayer = gridLayer;
        this.cellEditorControls = cellEditorControls;
        this.cellSelectionHandler = cellSelectionHandler;
    }

    public void onContextMenu(ContextMenuEvent event) {
        event.preventDefault();
        event.stopPropagation();
        int canvasX = CoordinateUtilities.getRelativeXOfEvent((DomEvent)event);
        int canvasY = CoordinateUtilities.getRelativeYOfEvent((DomEvent)event);
        boolean isShiftKeyDown = event.getNativeEvent().getShiftKey();
        boolean isControlKeyDown = event.getNativeEvent().getCtrlKey();
        ArrayList<CandidateGridWidget> candidateGridWidgets = new ArrayList<CandidateGridWidget>();
        for (GridWidget gridWidget : this.gridLayer.getGridWidgets()) {
            Integer uiRowIndex;
            if (DynamicReadOnlyUtils.isOnlyVisualChangeAllowed(gridWidget)) continue;
            GridData gridModel = gridWidget.getModel();
            Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)gridWidget, (Point2D)new Point2D((double)canvasX, (double)canvasY));
            Integer uiHeaderRowIndex = CoordinateUtilities.getUiHeaderRowIndex((GridWidget)gridWidget, (Point2D)ap);
            Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex((GridWidget)gridWidget, (double)ap.getX());
            if (Objects.nonNull(uiHeaderRowIndex) && Objects.nonNull(uiColumnIndex)) {
                GridColumn.HeaderMetaData hasCellEditorControls = (GridColumn.HeaderMetaData)((GridColumn)gridModel.getColumns().get(uiColumnIndex)).getHeaderMetaData().get(uiHeaderRowIndex);
                this.registerCandidateGridWidget(hasCellEditorControls, gridWidget.getComputedLocation().add(ap), uiHeaderRowIndex, uiColumnIndex, hasCellEditorControls, candidateGridWidgets, () -> this.cellSelectionHandler.selectHeaderCellIfRequired(uiHeaderRowIndex, uiColumnIndex, gridWidget, isShiftKeyDown, isControlKeyDown));
            }
            if (!Objects.nonNull(uiRowIndex = CoordinateUtilities.getUiRowIndex((GridWidget)gridWidget, (double)ap.getY())) || !Objects.nonNull(uiColumnIndex)) continue;
            GridCell hasCellEditorControls = gridModel.getCell(uiRowIndex.intValue(), uiColumnIndex.intValue());
            this.registerCandidateGridWidget(hasCellEditorControls, gridWidget.getComputedLocation().add(ap), uiRowIndex, uiColumnIndex, gridWidget, candidateGridWidgets, () -> this.cellSelectionHandler.selectCellIfRequired(uiRowIndex, uiColumnIndex, gridWidget, isShiftKeyDown, isControlKeyDown));
        }
        if (candidateGridWidgets.isEmpty()) {
            return;
        }
        CandidateGridWidget candidateGridWidget = (CandidateGridWidget)candidateGridWidgets.get(candidateGridWidgets.size() - 1);
        Point2D ap = candidateGridWidget.ap;
        int uiRowIndex = candidateGridWidget.uiRowIndex;
        int uiColumnIndex = candidateGridWidget.uiColumnIndex;
        Object binding = candidateGridWidget.binding;
        HasCellEditorControls hasCellEditorControls = candidateGridWidget.hasCellEditorControls;
        Optional<HasCellEditorControls.Editor> editor = hasCellEditorControls.getEditor();
        editor.ifPresent(e -> {
            candidateGridWidget.ensureCellSelectedCommand.execute();
            e.bind(binding, uiRowIndex, uiColumnIndex);
            this.cellEditorControls.show((HasCellEditorControls.Editor<?>)e, (int)ap.getX(), (int)ap.getY());
        });
    }

    private void registerCandidateGridWidget(Object hasCellEditorControls, Point2D ap, int uiRowIndex, int uiColumnIndex, Object binding, List<CandidateGridWidget> candidateGridWidgets, Command ensureCellSelectedCommand) {
        if (hasCellEditorControls == null) {
            return;
        }
        if (hasCellEditorControls instanceof HasCellEditorControls) {
            candidateGridWidgets.add(new CandidateGridWidget(ap, uiRowIndex, uiColumnIndex, binding, (HasCellEditorControls)hasCellEditorControls, ensureCellSelectedCommand));
        }
    }

    private class CandidateGridWidget {
        final Point2D ap;
        final int uiRowIndex;
        final int uiColumnIndex;
        final Object binding;
        final HasCellEditorControls hasCellEditorControls;
        final Command ensureCellSelectedCommand;

        CandidateGridWidget(Point2D ap, int uiRowIndex, int uiColumnIndex, Object binding, HasCellEditorControls hasCellEditorControls, Command ensureCellSelectedCommand) {
            this.ap = ap;
            this.uiRowIndex = uiRowIndex;
            this.uiColumnIndex = uiColumnIndex;
            this.binding = binding;
            this.hasCellEditorControls = hasCellEditorControls;
            this.ensureCellSelectedCommand = ensureCellSelectedCommand;
        }
    }
}

