/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNFlowActionsToolbox;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateConnectorAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateNodeAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.FlowActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.lookup.util.CommonLookups;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
@DMNFlowActionsToolbox
public class DMNFlowActionsToolboxFactory
extends AbstractActionsToolboxFactory {
    private final DefinitionUtils definitionUtils;
    private final CommonLookups commonLookups;
    private final Supplier<CreateConnectorAction> createConnectorActions;
    private final Supplier<CreateNodeAction> createNodeActions;
    private final Supplier<ActionsToolboxView> views;

    @Inject
    public DMNFlowActionsToolboxFactory(DefinitionUtils definitionUtils, CommonLookups commonLookups, @Any ManagedInstance<CreateConnectorAction> createConnectorActions, @Any ManagedInstance<CreateNodeAction> createNodeActions, @FlowActionsToolbox ManagedInstance<ActionsToolboxView> views) {
        this(definitionUtils, commonLookups, () -> createConnectorActions.get(), () -> createNodeActions.get(), () -> views.get());
    }

    DMNFlowActionsToolboxFactory(DefinitionUtils definitionUtils, CommonLookups commonLookups, Supplier<CreateConnectorAction> createConnectorActions, Supplier<CreateNodeAction> createNodeActions, Supplier<ActionsToolboxView> views) {
        this.definitionUtils = definitionUtils;
        this.commonLookups = commonLookups;
        this.createConnectorActions = createConnectorActions;
        this.createNodeActions = createNodeActions;
        this.views = views;
    }

    protected ActionsToolboxView<?> newViewInstance() {
        return this.views.get();
    }

    public Collection<ToolboxAction<AbstractCanvasHandler>> getActions(AbstractCanvasHandler canvasHandler, Element<?> element) {
        LinkedHashSet<ToolboxAction<AbstractCanvasHandler>> actions = new LinkedHashSet<ToolboxAction<AbstractCanvasHandler>>();
        Node node = (Node)element;
        Diagram diagram = canvasHandler.getDiagram();
        String defSetId = diagram.getMetadata().getDefinitionSetId();
        Set allowedConnectorIds = this.commonLookups.getAllowedConnectors(defSetId, node, 0, 10);
        for (String allowedConnectorId : allowedConnectorIds) {
            actions.add((ToolboxAction<AbstractCanvasHandler>)this.createConnectorActions.get().setEdgeId(allowedConnectorId));
            this.commonLookups.getAllowedTargetDefinitions(defSetId, diagram.getGraph(), node, allowedConnectorId, 0, 10).forEach(def -> actions.add((ToolboxAction<AbstractCanvasHandler>)this.createNodeActions.get().setEdgeId(allowedConnectorId).setNodeId(this.getDefinitionId(def))));
        }
        return actions;
    }

    private String getDefinitionId(Object def) {
        return this.getDefinitionManager().adapters().forDefinition().getId(def);
    }

    private DefinitionManager getDefinitionManager() {
        return this.definitionUtils.getDefinitionManager();
    }
}

