/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Optional;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.client.commands.NavigateToDRGEditorCommand;
import org.kie.workbench.common.dmn.client.commands.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.AbstractSessionPresenter;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public abstract class BaseNavigateCommand
extends AbstractCanvasGraphCommand {
    static final NoOperationGraphCommand NOP_GRAPH_COMMAND = new NoOperationGraphCommand();
    protected ExpressionEditorView.Presenter editor;
    protected SessionPresenter<AbstractClientFullSession, ?, Diagram> presenter;
    protected SessionManager sessionManager;
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    protected Optional<HasName> hasName;
    protected HasExpression hasExpression;

    public BaseNavigateCommand(ExpressionEditorView.Presenter editor, SessionPresenter<AbstractClientFullSession, ?, Diagram> presenter, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Optional<HasName> hasName, HasExpression hasExpression) {
        this.editor = editor;
        this.presenter = presenter;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.hasName = hasName;
        this.hasExpression = hasExpression;
    }

    protected void navigateToExpressionEditor(Optional<HasName> hasName, HasExpression hasExpression) {
        this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new NavigateToExpressionEditorCommand(this.editor, this.presenter, this.sessionManager, this.sessionCommandManager, hasName, hasExpression));
    }

    protected void navigateToDRGEditor(Optional<HasName> hasName, HasExpression hasExpression) {
        this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new NavigateToDRGEditorCommand(this.editor, this.presenter, this.sessionManager, this.sessionCommandManager, hasName, hasExpression));
    }

    protected void enableHandlers(boolean enabled) {
        CanvasHandler handler = this.getCanvasHandler();
        if (handler == null) {
            return;
        }
        Layer layer = handler.getCanvas().getLayer();
        if (enabled) {
            layer.enableHandlers();
            ((AbstractClientSession)this.sessionManager.getCurrentSession()).resume();
        } else {
            layer.disableHandlers();
            ((AbstractClientSession)this.sessionManager.getCurrentSession()).pause();
        }
    }

    protected void addExpressionEditorToCanvasWidget() {
        ((SessionPresenter.View)this.presenter.getView()).setCanvasWidget((IsWidget)ElementWrapperWidget.getWidget((HTMLElement)this.editor.getElement()));
    }

    protected void addDRGEditorToCanvasWidget() {
        ((SessionPresenter.View)this.presenter.getView()).setCanvasWidget(((AbstractSessionPresenter)this.presenter).getDisplayer().getView());
    }

    protected void hidePaletteWidget(boolean hidden) {
        this.presenter.getPalette().setVisible(!hidden);
    }

    private CanvasHandler getCanvasHandler() {
        return null != this.sessionManager.getCurrentSession() ? this.sessionManager.getCurrentSession().getCanvasHandler() : null;
    }

    public static class NoOperationGraphCommand
    extends AbstractGraphCommand {
        protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
            return GraphCommandResultBuilder.SUCCESS;
        }

        public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
            return GraphCommandResultBuilder.SUCCESS;
        }

        public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
            return GraphCommandResultBuilder.SUCCESS;
        }
    }
}

