/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands;

import java.util.Optional;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

public class DeleteCellValueCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private int rowIndex;
    private int columnIndex;
    private GridWidget gridWidget;
    private BaseUIModelMapper<?> uiModelMapper;
    private Optional<GridCellValue<?>> oldCellValue;

    public DeleteCellValueCommand(int rowIndex, int columnIndex, GridWidget gridWidget, BaseUIModelMapper<?> uiModelMapper) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.gridWidget = gridWidget;
        this.uiModelMapper = uiModelMapper;
        this.oldCellValue = Optional.ofNullable(this.extractGridCellValue(rowIndex, columnIndex));
    }

    GridCellValue<?> extractGridCellValue(int rowIndex, int columnIndex) {
        GridCell cell = this.gridWidget.getModel().getCell(rowIndex, columnIndex);
        return cell == null ? null : cell.getValue();
    }

    protected Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
                DeleteCellValueCommand.this.uiModelMapper.toDMNModel(DeleteCellValueCommand.this.rowIndex, DeleteCellValueCommand.this.columnIndex, Optional::empty);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
                DeleteCellValueCommand.this.uiModelMapper.toDMNModel(DeleteCellValueCommand.this.rowIndex, DeleteCellValueCommand.this.columnIndex, () -> DeleteCellValueCommand.this.oldCellValue);
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
                DeleteCellValueCommand.this.gridWidget.getModel().deleteCell(DeleteCellValueCommand.this.rowIndex, DeleteCellValueCommand.this.columnIndex);
                DeleteCellValueCommand.this.gridWidget.getLayer().batch();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
                DeleteCellValueCommand.this.oldCellValue.ifPresent(v -> DeleteCellValueCommand.this.gridWidget.getModel().setCell(DeleteCellValueCommand.this.rowIndex, DeleteCellValueCommand.this.columnIndex, v));
                DeleteCellValueCommand.this.gridWidget.getLayer().batch();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

