/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.components.palette.widget;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.client.components.palette.widget.DMNPaletteItemWidget;
import org.kie.workbench.common.dmn.client.components.palette.widget.DMNPaletteWidgetView;
import org.kie.workbench.common.stunner.client.widgets.palette.BS3PaletteWidget;
import org.kie.workbench.common.stunner.client.widgets.palette.PaletteWidget;
import org.kie.workbench.common.stunner.client.widgets.palette.factory.BS3PaletteViewFactory;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.components.palette.AbstractPalette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionsPalette;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;

@Dependent
public class DMNPaletteWidget
extends AbstractPalette<DefinitionsPalette>
implements BS3PaletteWidget<DefinitionsPalette>,
IsElement {
    public static final String BG_COLOR = "#D3D3D3";
    private static final int GLYPH_ICON_SIZE = 30;
    protected final ClientFactoryService clientFactoryServices;
    protected PaletteWidget.ItemDropCallback itemDropCallback;
    protected PaletteWidget.ItemDragStartCallback itemDragStartCallback;
    protected PaletteWidget.ItemDragUpdateCallback itemDragUpdateCallback;
    private ManagedInstance<DMNPaletteItemWidget> paletteItemWidgets;
    private BS3PaletteViewFactory viewFactory;
    private DMNPaletteWidgetView view;

    @Inject
    public DMNPaletteWidget(ShapeManager shapeManager, ClientFactoryService clientFactoryServices, DMNPaletteWidgetView view, ManagedInstance<DMNPaletteItemWidget> paletteItemWidgets) {
        super(shapeManager);
        this.clientFactoryServices = clientFactoryServices;
        this.view = view;
        this.paletteItemWidgets = paletteItemWidgets;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
        this.view.setBackgroundColor(BG_COLOR);
        this.view.showEmptyView(true);
    }

    public BS3PaletteWidget<DefinitionsPalette> onItemDrop(PaletteWidget.ItemDropCallback callback) {
        this.itemDropCallback = callback;
        return this;
    }

    public BS3PaletteWidget<DefinitionsPalette> onItemDragStart(PaletteWidget.ItemDragStartCallback callback) {
        this.itemDragStartCallback = callback;
        return this;
    }

    public BS3PaletteWidget<DefinitionsPalette> onItemDragUpdate(PaletteWidget.ItemDragUpdateCallback callback) {
        this.itemDragUpdateCallback = callback;
        return this;
    }

    public void onDragStart(String definitionId, double x, double y) {
        if (null != this.itemDragStartCallback) {
            Object definition = this.clientFactoryServices.getClientFactoryManager().newDefinition(definitionId);
            ShapeFactory factory = this.getShapeFactory();
            this.itemDragStartCallback.onDragStartItem(definition, factory, x, y);
        }
    }

    public void onDragProxyMove(String definitionId, double x, double y) {
        if (null != this.itemDragUpdateCallback) {
            Object definition = this.clientFactoryServices.getClientFactoryManager().newDefinition(definitionId);
            ShapeFactory factory = this.getShapeFactory();
            this.itemDragUpdateCallback.onDragUpdateItem(definition, factory, x, y);
        }
    }

    public void onDragProxyComplete(String definitionId, double x, double y) {
        if (null != this.itemDropCallback) {
            Object definition = this.clientFactoryServices.getClientFactoryManager().newDefinition(definitionId);
            ShapeFactory factory = this.getShapeFactory();
            this.itemDropCallback.onDropItem(definition, factory, x, y);
        }
    }

    public BS3PaletteWidget setViewFactory(BS3PaletteViewFactory viewFactory) {
        this.viewFactory = viewFactory;
        return this;
    }

    public Glyph getShapeGlyph(String definitionId) {
        return this.getShapeFactory().getGlyph(definitionId);
    }

    protected String getPaletteItemId(int index) {
        return ((DefinitionPaletteItem)((DefinitionsPalette)this.paletteDefinition).getItems().get(index)).getId();
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    protected ShapeFactory getShapeFactory() {
        return this.shapeManager.getDefaultShapeSet(((DefinitionsPalette)this.paletteDefinition).getDefinitionSetId()).getShapeFactory();
    }

    protected void beforeBind() {
        this.view.clear();
        this.view.showEmptyView(false);
    }

    protected AbstractPalette<DefinitionsPalette> bind() {
        DefinitionsPalette palette = (DefinitionsPalette)this.paletteDefinition;
        if (null != palette) {
            palette.getItems().forEach(pi -> {
                DMNPaletteItemWidget paletteItemWidget = (DMNPaletteItemWidget)this.paletteItemWidgets.get();
                paletteItemWidget.initialize((DefinitionPaletteItem)pi, (ShapeFactory<?, ?>)this.getShapeFactory(), (id, mouseX, mouseY, itemX, itemY) -> {
                    this.view.showDragProxy(id, mouseX, mouseY, 30.0, 30.0);
                    return true;
                });
                this.view.add(paletteItemWidget);
            });
        }
        return this;
    }

    public void unbind() {
        if (null != this.paletteDefinition) {
            this.view.clear();
            this.view.showEmptyView(true);
            this.paletteDefinition = null;
        }
    }

    @PreDestroy
    protected void doDestroy() {
        this.paletteItemWidgets.destroyAll();
        this.viewFactory.destroy();
        this.view.destroy();
        this.itemDropCallback = null;
    }

    public void setVisible(boolean visible) {
        this.view.showEmptyView(!visible);
    }
}

