/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.client.commands.SetExpressionTypeCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.BaseExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.toolbar.ToolbarCommand;
import org.kie.workbench.common.stunner.client.widgets.toolbar.impl.EditorToolbar;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.uberfire.mvp.Command;

@Dependent
public class ExpressionEditor
implements ExpressionEditorView.Presenter {
    private ExpressionEditorView view;
    private SessionManager sessionManager;
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private Optional<Command> exitCommand;
    private Optional<HasName> hasName;
    private HasExpression hasExpression;
    private ToolbarCommandStateHandler toolbarCommandStateHandler;
    private List<ExpressionEditorDefinition<Expression>> expressionEditorDefinitions = new ArrayList<ExpressionEditorDefinition<Expression>>();

    public ExpressionEditor() {
    }

    @Inject
    public ExpressionEditor(ExpressionEditorView view, SessionManager sessionManager, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Instance<ExpressionEditorDefinition> expressionEditorDefinitionBeans) {
        this.view = view;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.view.init(this);
        expressionEditorDefinitionBeans.forEach(t -> this.expressionEditorDefinitions.add((ExpressionEditorDefinition<Expression>)t));
        this.expressionEditorDefinitions.sort((o1, o2) -> o1.getType().ordinal() - o2.getType().ordinal());
        this.view.setExpressionEditorTypes(this.expressionEditorDefinitions);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public void init(SessionPresenter<AbstractClientFullSession, ?, Diagram> presenter) {
        this.toolbarCommandStateHandler = new ToolbarCommandStateHandler((EditorToolbar)presenter.getToolbar());
    }

    @Override
    public void setHasName(Optional<HasName> hasName) {
        this.hasName = hasName;
    }

    @Override
    public void setHasExpression(HasExpression hasExpression) {
        this.hasExpression = hasExpression;
        Expression e = hasExpression.getExpression();
        this.setExpression(Optional.ofNullable(e));
        this.toolbarCommandStateHandler.enter();
    }

    @Override
    public void setExpression(Optional<Expression> expression) {
        if (!expression.isPresent()) {
            this.expressionEditorDefinitions.stream().filter(ed -> !ed.getModelClass().isPresent()).findFirst().ifPresent(ed -> {
                this.view.selectExpressionEditorType(ed.getType());
                this.view.setSubEditor(ed.getEditor().getView());
            });
        } else {
            this.expressionEditorDefinitions.stream().filter(ed -> ed.getModelClass().isPresent()).filter(ed -> ((Expression)ed.getModelClass().get()).getClass().equals(((Expression)expression.get()).getClass())).findFirst().ifPresent(ed -> {
                this.view.selectExpressionEditorType(ed.getType());
                BaseExpressionEditorView.Editor editor = ed.getEditor();
                this.view.setSubEditor(editor.getView());
                editor.setHasName(this.hasName);
                editor.setExpression((Expression)expression.get());
            });
        }
    }

    @Override
    public void setExitCommand(Command exitCommand) {
        this.exitCommand = Optional.ofNullable(exitCommand);
    }

    @Override
    public void exit() {
        this.exitCommand.ifPresent(c -> {
            this.toolbarCommandStateHandler.exit();
            c.execute();
        });
    }

    @Override
    public void onExpressionTypeChanged(ExpressionType type) {
        Optional expression = this.expressionEditorDefinitions.stream().filter(e -> e.getType().equals((Object)type)).map(ExpressionEditorDefinition::getModelClass).findFirst().get();
        this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (org.kie.workbench.common.stunner.core.command.Command)new SetExpressionTypeCommand(this.hasExpression, expression, this));
    }

    ToolbarCommandStateHandler getToolbarCommandStateHandler() {
        return this.toolbarCommandStateHandler;
    }

    static class ToolbarCommandStateHandler {
        private EditorToolbar toolbar;
        boolean visitGraphToolbarCommandEnabled = false;
        boolean clearToolbarCommandEnabled = false;
        boolean clearStatesToolbarCommandEnabled = false;
        boolean deleteSelectionToolbarCommandEnabled = false;
        boolean switchGridToolbarCommandEnabled = false;
        boolean undoToolbarCommandEnabled = false;
        boolean redoToolbarCommandEnabled = false;
        boolean validateToolbarCommandEnabled = false;
        boolean exportToPngToolbarCommandEnabled = false;
        boolean exportToJpgToolbarCommandEnabled = false;
        boolean exportToPdfToolbarCommandEnabled = false;

        private ToolbarCommandStateHandler(EditorToolbar toolbar) {
            this.toolbar = toolbar;
        }

        private void enter() {
            this.visitGraphToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getVisitGraphToolbarCommand());
            this.clearToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getClearToolbarCommand());
            this.clearStatesToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getClearStatesToolbarCommand());
            this.deleteSelectionToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getDeleteSelectionToolbarCommand());
            this.switchGridToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getSwitchGridToolbarCommand());
            this.undoToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getUndoToolbarCommand());
            this.redoToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getRedoToolbarCommand());
            this.validateToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getValidateToolbarCommand());
            this.exportToPngToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getExportToPngToolbarCommand());
            this.exportToJpgToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getExportToJpgToolbarCommand());
            this.exportToPdfToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getExportToPdfToolbarCommand());
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getVisitGraphToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getClearToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getClearStatesToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getDeleteSelectionToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getSwitchGridToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getUndoToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getRedoToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getValidateToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToPngToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToJpgToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToPdfToolbarCommand(), false);
        }

        private void exit() {
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getVisitGraphToolbarCommand(), this.visitGraphToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getClearToolbarCommand(), this.clearToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getClearStatesToolbarCommand(), this.clearStatesToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getDeleteSelectionToolbarCommand(), this.deleteSelectionToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getSwitchGridToolbarCommand(), this.switchGridToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getUndoToolbarCommand(), this.undoToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getRedoToolbarCommand(), this.redoToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getValidateToolbarCommand(), this.validateToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToPngToolbarCommand(), this.exportToPngToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToJpgToolbarCommand(), this.exportToJpgToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToPdfToolbarCommand(), this.exportToPdfToolbarCommandEnabled);
        }

        private void enableToolbarCommand(ToolbarCommand command, boolean enabled) {
            if (enabled) {
                this.toolbar.enable(command);
            } else {
                this.toolbar.disable(command);
            }
        }
    }
}

