/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.Select;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;

@Templated
@Dependent
public class ExpressionEditorViewImpl
implements ExpressionEditorView {
    private ExpressionEditorView.Presenter presenter;
    @DataField(value="exitButton")
    private Div exitButton;
    @DataField(value="expressionEditor")
    private Div expressionEditor;
    @DataField(value="expressionEditorDefinition")
    private Select expressionEditorDefinition;
    private Document document;
    private TranslationService ts;

    public ExpressionEditorViewImpl() {
    }

    @Inject
    public ExpressionEditorViewImpl(Div exitButton, Div expressionEditor, Select expressionEditorDefinition, Document document, TranslationService ts) {
        this.exitButton = exitButton;
        this.expressionEditorDefinition = expressionEditorDefinition;
        this.expressionEditor = expressionEditor;
        this.document = document;
        this.ts = ts;
    }

    public void init(ExpressionEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setExpressionEditorTypes(List<ExpressionEditorDefinition<Expression>> expressionEditorDefinitions) {
        expressionEditorDefinitions.forEach(t -> this.expressionEditorDefinition.add((HTMLElement)this.makeExpressionDefinitionWidget((ExpressionEditorDefinition<? extends Expression>)t)));
    }

    @Override
    public void selectExpressionEditorType(ExpressionType type) {
        this.expressionEditorDefinition.setSelectedIndex(type.ordinal());
    }

    @Override
    public void setSubEditor(IsElement editor) {
        DOMUtil.removeAllChildren((Node)this.expressionEditor);
        this.expressionEditor.appendChild((Node)editor.getElement());
    }

    private Option makeExpressionDefinitionWidget(ExpressionEditorDefinition<? extends Expression> definition) {
        Option o = (Option)this.document.createElement("option");
        o.setValue(definition.getType().name());
        o.setText(definition.getName());
        return o;
    }

    @EventHandler(value={"exitButton"})
    void onClickExitButton(ClickEvent event) {
        this.presenter.exit();
    }

    @EventHandler(value={"expressionEditorDefinition"})
    void onExpressionTypeSelectionChange(ChangeEvent event) {
        Option o = (Option)this.expressionEditorDefinition.getOptions().item(this.expressionEditorDefinition.getSelectedIndex());
        String type = o.getValue();
        this.presenter.onExpressionTypeChanged(ExpressionType.valueOf(type));
    }
}

