/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types;

import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.Optional;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.BaseExpressionEditorView;
import org.kie.workbench.common.dmn.client.widgets.grid.BoundaryTransformMediator;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

public abstract class BaseExpressionEditorViewImpl<P extends BaseExpressionEditorView.Editor, E extends Expression>
implements BaseExpressionEditorView<P, E> {
    private static final double VP_SCALE = 1.0;
    public static final int LIENZO_PANEL_WIDTH = 1000;
    public static final int LIENZO_PANEL_HEIGHT = 450;
    protected TranslationService ts;
    protected SessionManager sessionManager;
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    protected BaseExpressionEditorView.Editor editor;
    protected GridWidget gridWidget;
    protected Optional<HasName> hasName = Optional.empty();
    protected Optional<E> expression = Optional.empty();
    protected TransformMediator defaultTransformMediator;
    protected final GridLienzoPanel gridPanel = this.defaultGridPanel();
    protected final DefaultGridLayer gridLayer = this.defaultGridLayer();
    protected final RestrictedMousePanMediator mousePanMediator = new RestrictedMousePanMediator((GridLayer)this.gridLayer);
    protected BaseUIModelMapper<E> uiModelMapper;

    public GridLienzoPanel defaultGridPanel() {
        return new GridLienzoPanel(1000, 450){

            public void onResize() {
                Scheduler.get().scheduleDeferred(() -> {
                    this.updatePanelSize();
                    TransformMediator restriction = BaseExpressionEditorViewImpl.this.mousePanMediator.getTransformMediator();
                    Transform transform = restriction.adjust(BaseExpressionEditorViewImpl.this.gridLayer.getViewport().getTransform(), BaseExpressionEditorViewImpl.this.gridLayer.getVisibleBounds());
                    BaseExpressionEditorViewImpl.this.gridLayer.getViewport().setTransform(transform);
                    BaseExpressionEditorViewImpl.this.gridLayer.draw();
                });
            }
        };
    }

    public DefaultGridLayer defaultGridLayer() {
        return new DefaultGridLayer(){

            public TransformMediator getDefaultTransformMediator() {
                return BaseExpressionEditorViewImpl.this.defaultTransformMediator;
            }
        };
    }

    protected BaseExpressionEditorViewImpl(TranslationService ts, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager) {
        this.ts = ts;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.uiModelMapper = this.makeUiModelMapper();
        this.setupGridPanel();
        this.setupGridWidget();
        this.setupGridWidgetPanControl();
    }

    protected void setupGridPanel() {
        Transform transform = new Transform().scale(1.0);
        this.gridPanel.getViewport().setTransform(transform);
        this.gridPanel.add(this.gridLayer);
        this.gridPanel.getElement().setId("dmn_container_" + Document.get().createUniqueId());
    }

    protected void setupGridWidget() {
        this.gridWidget = this.makeGridWidget();
        this.gridLayer.add((IPrimitive)this.gridWidget);
        this.gridLayer.select(this.gridWidget);
        this.gridLayer.enterPinnedMode(this.gridWidget, () -> {});
    }

    protected void setupGridWidgetPanControl() {
        this.defaultTransformMediator = new BoundaryTransformMediator(this.gridWidget);
        this.mousePanMediator.setTransformMediator(this.defaultTransformMediator);
        this.mousePanMediator.setBatchDraw(true);
        this.gridPanel.getViewport().getMediators().push((IMediator)this.mousePanMediator);
    }

    @Override
    public void setHasName(Optional<HasName> hasName) {
        this.hasName = hasName;
        this.hasName.ifPresent(hn -> this.gridLayer.batch());
    }

    public HandlerRegistration addContextMenuHandler(ContextMenuHandler handler) {
        return this.gridPanel.addDomHandler((EventHandler)handler, ContextMenuEvent.getType());
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.gridPanel.addKeyDownHandler(handler);
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.gridPanel.addMouseDownHandler(handler);
    }

    public void fireEvent(GwtEvent<?> event) {
        this.gridPanel.fireEvent(event);
    }

    public void onResize() {
        this.gridPanel.onResize();
    }
}

