/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.shape.view;

import com.ait.lienzo.client.core.Attribute;
import com.ait.lienzo.client.core.Context2D;
import com.ait.lienzo.client.core.shape.AbstractDirectionalMultiPointShape;
import com.ait.lienzo.client.core.shape.Attributes;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.PathPartList;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Point2DArray;
import com.ait.lienzo.shared.core.types.ShapeType;
import java.util.List;

public class DirectionalLine
extends AbstractDirectionalMultiPointShape<DirectionalLine> {
    public DirectionalLine(double x1, double y1, double x2, double y2) {
        this(new Point2D(x1, y1), new Point2D(x2, y2));
    }

    public DirectionalLine(Point2D start, Point2D end) {
        this(new Point2DArray(start, new Point2D[]{end}));
    }

    public DirectionalLine(Point2DArray points) {
        super(ShapeType.LINE);
        this.setControlPoints(points);
    }

    public DirectionalLine setControlPoints(Point2DArray points) {
        this.getAttributes().setControlPoints(points);
        return this.refresh();
    }

    public Point2DArray getControlPoints() {
        return this.getAttributes().getControlPoints();
    }

    public DirectionalLine refresh() {
        this.getPathPartList().clear();
        return this;
    }

    public boolean isControlPointShape() {
        return true;
    }

    protected boolean fill(Context2D context, Attributes attr, double alpha) {
        return false;
    }

    public boolean parse(Attributes attr) {
        Point2DArray points = attr.getControlPoints();
        Point2D p1 = points.get(0);
        double x1 = p1.getX();
        double y1 = p1.getY();
        Point2D p2 = points.get(1);
        double x2 = p2.getX();
        double y2 = p2.getY();
        PathPartList list = this.getPathPartList();
        list.M(x1, y1);
        list.L(x2, y2);
        return true;
    }

    public Point2D getTailOffsetPoint() {
        return this.getControlPoints().get(0);
    }

    public Point2D getHeadOffsetPoint() {
        return this.getControlPoints().get(1);
    }

    public DirectionalLine setPoint2DArray(Point2DArray points) {
        return this.setControlPoints(points);
    }

    public Point2DArray getPoint2DArray() {
        return this.getControlPoints();
    }

    public List<Attribute> getBoundingBoxAttributes() {
        return this.getBoundingBoxAttributesComposed(new Attribute[]{Attribute.CONTROL_POINTS});
    }

    public BoundingBox getBoundingBox() {
        if (this.getPathPartList().size() < 1) {
            return new BoundingBox(0.0, 0.0, 0.0, 0.0);
        }
        return this.getPathPartList().getBoundingBox();
    }
}

