/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.model.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.screens.server.management.model.ConnectionType;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ServerRef;
import org.kie.workbench.common.screens.server.management.service.ContainerAlreadyRegisteredException;

@Portable
public class ServerRefImpl
implements ServerRef {
    private String id;
    private String url;
    private String name;
    private String username;
    private String password;
    private ContainerStatus status;
    private ConnectionType connectionType;
    private final Map<String, String> properties = new HashMap<String, String>();
    protected final Map<String, ContainerRef> containersRef = new HashMap<String, ContainerRef>();

    public ServerRefImpl() {
    }

    public ServerRefImpl(String id, String url, String name, String username, String password, ContainerStatus status, ConnectionType connectionType, Map<String, String> properties, Collection<ContainerRef> containerRefs) {
        this.id = id;
        this.url = url;
        this.name = name;
        this.username = username;
        this.password = password;
        this.connectionType = connectionType;
        this.status = status;
        if (properties != null) {
            this.properties.putAll(properties);
        }
        if (containerRefs != null && !containerRefs.isEmpty()) {
            for (ContainerRef containerConfig : containerRefs) {
                containerConfig.setStatus(ContainerStatus.STOPPED);
                this.containersRef.put(containerConfig.getId(), containerConfig);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUrl() {
        if (this.url == null) {
            return this.id;
        }
        return this.url;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public ContainerStatus getStatus() {
        return this.status;
    }

    @Override
    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public Collection<ContainerRef> getContainersRef() {
        return this.containersRef.values();
    }

    @Override
    public boolean hasContainerRef(String id) {
        return this.containersRef.containsKey(id);
    }

    @Override
    public ContainerRef getContainerRef(String containerId) {
        return this.containersRef.get(containerId);
    }

    @Override
    public void addContainerRef(ContainerRef containerRef) {
        if (this.containersRef.containsKey(containerRef.getId())) {
            throw new ContainerAlreadyRegisteredException(containerRef.getId());
        }
        this.containersRef.put(containerRef.getId(), containerRef);
    }

    @Override
    public void deleteContainer(String containerId) {
        this.containersRef.remove(containerId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerRefImpl)) {
            return false;
        }
        ServerRefImpl serverRef = (ServerRefImpl)o;
        return this.id.equals(serverRef.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

