/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import com.thoughtworks.xstream.XStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.GAV;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ServerRef;
import org.kie.workbench.common.screens.server.management.model.impl.ContainerRefImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ServerRefImpl;
import org.kie.workbench.common.screens.server.management.service.ContainerAlreadyRegisteredException;
import org.kie.workbench.common.screens.server.management.service.ContainerNotFoundException;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class ServerReferenceStorageImpl {
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Named(value="systemFS")
    private FileSystem fileSystem;
    private XStream xs = new XStream();

    public boolean exists(ServerRef serverRef) {
        return this.ioService.exists(this.buildPath(serverRef));
    }

    public void forceRegister(ServerRef serverRef) {
        Path path = this.buildPath(serverRef);
        this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
    }

    public void register(ServerRef serverRef) {
        if (this.exists(serverRef)) {
            throw new RuntimeException();
        }
        Path path = this.buildPath(serverRef);
        this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
    }

    public Collection<ServerRef> listRegisteredServers() {
        ArrayList<ServerRef> result = new ArrayList<ServerRef>();
        Path dir = this.buildPath((String)null);
        try {
            for (Path registeredServer : this.ioService.newDirectoryStream(dir)) {
                try {
                    result.add(this.restoreConfig(registeredServer));
                }
                catch (Exception ignore) {
                    this.ioService.delete(registeredServer, new DeleteOption[0]);
                }
            }
        }
        catch (NotDirectoryException notDirectoryException) {
            // empty catch block
        }
        return result;
    }

    private ServerRef restoreConfig(Path registeredServer) {
        try {
            ServerRef serverRef = (ServerRef)this.xs.fromXML(this.ioService.readAllString(registeredServer));
            return new ServerRefImpl(serverRef.getId(), serverRef.getName(), serverRef.getUsername(), serverRef.getPassword(), ContainerStatus.LOADING, serverRef.getConnectionType(), serverRef.getProperties(), serverRef.getContainersRef());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void unregister(ServerRef serverRef) {
        this.ioService.delete(this.buildPath(serverRef), new DeleteOption[0]);
    }

    private Path buildPath(ServerRef serverRef) {
        if (serverRef == null) {
            return this.buildPath((String)null);
        }
        return this.buildPath(serverRef.getId());
    }

    private Path buildPath(String endpoint) {
        if (endpoint != null) {
            return this.fileSystem.getPath("servers", new String[]{"remote", this.toHex(endpoint) + ".xml"});
        }
        return this.fileSystem.getPath("servers", new String[]{"remote"});
    }

    public String toHex(String arg) {
        return String.format("%x", new BigInteger(1, arg.toLowerCase().getBytes(Charset.forName("UTF-8"))));
    }

    public void createContainer(ContainerRef containerRef) {
        Path path = this.buildPath(containerRef.getServerId());
        ServerRef serverRef = this.loadServerRef(containerRef.getServerId());
        if (serverRef != null) {
            if (serverRef.hasContainerRef(containerRef.getId())) {
                throw new ContainerAlreadyRegisteredException(containerRef.getId());
            }
            serverRef.addContainerRef(containerRef);
            this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
        }
    }

    public ServerRef loadServerRef(String serverId) {
        Path path = this.buildPath(serverId);
        return this.restoreConfig(path);
    }

    public void deleteContainer(String serverId, String containerId) {
        Path path = this.buildPath(serverId);
        ServerRef serverRef = this.loadServerRef(serverId);
        if (serverRef != null) {
            serverRef.deleteContainer(containerId);
            this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
        }
    }

    public void updateContainer(String serverId, String containerId, GAV releaseId) {
        Path path = this.buildPath(serverId);
        ServerRef serverRef = this.loadServerRef(serverId);
        if (serverRef != null) {
            ContainerRef containerRef = serverRef.getContainerRef(containerId);
            if (containerRef == null) {
                throw new ContainerNotFoundException(containerId);
            }
            serverRef.deleteContainer(containerId);
            serverRef.addContainerRef((ContainerRef)new ContainerRefImpl(serverId, containerId, containerRef.getStatus(), releaseId, containerRef.getScannerStatus(), containerRef.getPollInterval()));
            this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
        }
    }

    public void updateContainer(String serverId, String containerId, Long pollInterval) {
        Path path = this.buildPath(serverId);
        ServerRef serverRef = this.loadServerRef(serverId);
        if (serverRef != null) {
            ContainerRef containerRef = serverRef.getContainerRef(containerId);
            if (containerRef == null) {
                throw new ContainerNotFoundException(containerId);
            }
            serverRef.deleteContainer(containerId);
            serverRef.addContainerRef((ContainerRef)new ContainerRefImpl(serverId, containerId, containerRef.getStatus(), containerRef.getReleasedId(), containerRef.getScannerStatus(), pollInterval));
            this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
        }
    }
}

