/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.storage;

import com.thoughtworks.xstream.XStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.workbench.common.screens.server.management.backend.storage.migration.ServerTemplateMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class ServerTemplateVFSStorage
implements KieServerTemplateStorage {
    private static final Logger logger = LoggerFactory.getLogger(ServerTemplateVFSStorage.class);
    private IOService ioService;
    private FileSystem fileSystem;
    private final XStream xs = new XStream();

    public ServerTemplateVFSStorage() {
    }

    @Inject
    public ServerTemplateVFSStorage(@Named(value="configIO") IOService ioService, @Named(value="systemFS") FileSystem fileSystem) {
        this.ioService = ioService;
        this.fileSystem = fileSystem;
    }

    @PostConstruct
    public void init() {
        ServerTemplateMigration.migrate(this.buildPath(null), this.ioService, this.xs, this);
    }

    public ServerTemplate store(ServerTemplate serverTemplate) {
        logger.debug("About to store server template {}", (Object)serverTemplate);
        Path path = this.buildPath(serverTemplate.getId());
        if (!this.ioService.exists(path)) {
            try {
                this.ioService.startBatch(path.getFileSystem());
                this.ioService.write(path, this.xs.toXML((Object)serverTemplate), new OpenOption[0]);
            }
            finally {
                this.ioService.endBatch();
            }
            logger.debug("Server template {} stored successfully");
            return serverTemplate;
        }
        throw new IllegalArgumentException("Server template with id " + serverTemplate.getId() + " is already stored");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerTemplateKey> loadKeys() {
        logger.debug("About to load all available server templates (as keys only)...");
        ArrayList<ServerTemplateKey> result = new ArrayList<ServerTemplateKey>();
        Path dir = this.buildPath(null);
        try {
            this.ioService.startBatch(dir.getFileSystem());
            for (Path registeredServer : this.ioService.newDirectoryStream(dir)) {
                try {
                    ServerTemplate serverTemplate = this.readServerTemplate(registeredServer);
                    logger.debug("Found server template {}, taking its short key version...");
                    result.add(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
                }
                catch (Exception ignore) {
                    this.ioService.delete(registeredServer, new DeleteOption[0]);
                }
            }
            logger.debug("All found server template keys {}", result);
            ArrayList<ServerTemplateKey> arrayList = result;
            return arrayList;
        }
        catch (NotDirectoryException ignore) {
            logger.debug("No directory found {}, returning empty result", (Object)dir);
            ArrayList<ServerTemplateKey> arrayList = result;
            return arrayList;
        }
        finally {
            this.ioService.endBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerTemplate> load() {
        logger.debug("About to load all available server templates...");
        ArrayList<ServerTemplate> result = new ArrayList<ServerTemplate>();
        Path dir = this.buildPath(null);
        try {
            this.ioService.startBatch(dir.getFileSystem());
            for (Path registeredServer : this.ioService.newDirectoryStream(dir)) {
                try {
                    ServerTemplate serverTemplate = this.readServerTemplate(registeredServer);
                    logger.debug("Found server template {}", (Object)serverTemplate);
                    result.add(serverTemplate);
                }
                catch (Exception ignore) {
                    this.ioService.delete(registeredServer, new DeleteOption[0]);
                }
            }
            logger.debug("All found server templates {}", result);
            ArrayList<ServerTemplate> arrayList = result;
            return arrayList;
        }
        catch (NotDirectoryException ignore) {
            logger.debug("No directory found {}, returning empty result", (Object)dir);
            ArrayList<ServerTemplate> arrayList = result;
            return arrayList;
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public ServerTemplate load(String identifier) {
        logger.debug("About to load server template for {}", (Object)identifier);
        Path path = this.buildPath(identifier);
        ServerTemplate serverTemplate = this.readServerTemplate(path);
        logger.debug("Server template loaded {}", (Object)serverTemplate);
        return serverTemplate;
    }

    public boolean exists(String identifier) {
        boolean serverTemplateExists = this.ioService.exists(this.buildPath(identifier));
        logger.debug("Server with id {} exists = {}", (Object)identifier, (Object)serverTemplateExists);
        return serverTemplateExists;
    }

    public ServerTemplate update(ServerTemplate serverTemplate) {
        logger.debug("About to update server template {}", (Object)serverTemplate);
        Path path = this.buildPath(serverTemplate.getId());
        try {
            this.ioService.startBatch(path.getFileSystem());
            this.ioService.write(path, this.xs.toXML((Object)serverTemplate), new OpenOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
        logger.debug("Server template {} updated successfully", (Object)serverTemplate);
        return serverTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate delete(String identifier) {
        logger.debug("About to remove server template with id {}", (Object)identifier);
        Path path = this.buildPath(identifier);
        ServerTemplate serverTemplate = null;
        try {
            this.ioService.startBatch(path.getFileSystem());
            serverTemplate = this.readServerTemplate(path);
            this.ioService.delete(path, new DeleteOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
        logger.debug("Server template with id {}, removed successfully", (Object)identifier);
        return serverTemplate;
    }

    protected ServerTemplate readServerTemplate(Path registeredServer) {
        try {
            if (this.ioService.exists(registeredServer)) {
                ServerTemplate serverTemplate = (ServerTemplate)this.xs.fromXML(this.ioService.readAllString(registeredServer));
                return serverTemplate;
            }
        }
        catch (Exception ex) {
            logger.error("Error reading KieServerInstance definition from path {}", (Object)registeredServer, (Object)ex);
        }
        return null;
    }

    protected Path buildPath(String identifier) {
        if (identifier != null) {
            return this.fileSystem.getPath("servers", new String[]{"remote", this.toHex(identifier) + "-template.xml"});
        }
        return this.fileSystem.getPath("servers", new String[]{"remote"});
    }

    protected String toHex(String arg) {
        if (this.isHex(arg)) {
            return arg;
        }
        return String.format("%x", new BigInteger(1, arg.toLowerCase().getBytes(Charset.forName("UTF-8"))));
    }

    protected boolean isHex(String endpoint) {
        try {
            new BigInteger(endpoint, 16);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

