/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client;

import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.screens.server.management.client.box.BoxPresenter;
import org.kie.workbench.common.screens.server.management.client.box.BoxType;
import org.kie.workbench.common.screens.server.management.client.events.HeaderClearSelectionEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderDeleteEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderFilterEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderRefreshEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderSelectAllEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderStartEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderStopEvent;
import org.kie.workbench.common.screens.server.management.client.header.HeaderPresenter;
import org.kie.workbench.common.screens.server.management.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.server.management.events.ContainerCreated;
import org.kie.workbench.common.screens.server.management.events.ContainerDeleted;
import org.kie.workbench.common.screens.server.management.events.ServerConnected;
import org.kie.workbench.common.screens.server.management.events.ServerDeleted;
import org.kie.workbench.common.screens.server.management.events.ServerOnError;
import org.kie.workbench.common.screens.server.management.model.ConnectionType;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ServerRef;
import org.kie.workbench.common.screens.server.management.service.ServerManagementService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.commons.data.Pair;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.mvp.Command;

@ApplicationScoped
@WorkbenchScreen(identifier="ServerManagementBrowser")
public class ServerManagementBrowserPresenter {
    private final View view;
    private final HeaderPresenter header;
    private final Caller<ServerManagementService> service;
    private final SyncBeanManager beanManager;
    private Map<Object, BoxPresenter> containers = new HashMap<Object, BoxPresenter>();

    @Inject
    public ServerManagementBrowserPresenter(View view, SyncBeanManager beanManager, HeaderPresenter header, Caller<ServerManagementService> service) {
        this.view = view;
        this.beanManager = beanManager;
        this.header = header;
        this.service = service;
        this.view.setHeader(header);
    }

    @OnOpen
    public void onOpen() {
        ((ServerManagementService)this.service.call((RemoteCallback)new RemoteCallback<Collection<ServerRef>>(){

            public void callback(Collection<ServerRef> response) {
                ServerManagementBrowserPresenter.this.loadServers(response);
            }
        })).listServers();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.title();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.view;
    }

    void onHeaderRefresh(@Observes HeaderRefreshEvent event) {
        if (event.getContext().equals(this.header)) {
            ((ServerManagementService)this.service.call()).refresh();
        }
    }

    void onHeaderFilter(@Observes HeaderFilterEvent event) {
        if (event.getContext().equals(this.header)) {
            for (BoxPresenter container : this.containers.values()) {
                container.filter(event.getFilter());
            }
        }
    }

    void onHeaderSelectAll(@Observes HeaderSelectAllEvent event) {
        if (event.getContext().equals(this.header)) {
            for (BoxPresenter container : this.containers.values()) {
                if (container.isVisible()) {
                    container.select(true);
                    continue;
                }
                container.select(false);
            }
        }
    }

    void onHeaderClearSelection(@Observes HeaderClearSelectionEvent event) {
        if (event.getContext().equals(this.header)) {
            for (BoxPresenter container : this.containers.values()) {
                container.select(false);
            }
        }
    }

    void onHeaderStart(@Observes HeaderStartEvent event) {
        if (event.getContext().equals(this.header)) {
            ((ServerManagementService)this.service.call()).startContainers((Map)this.getSelectedItems().getK2());
        }
    }

    void onHeaderStop(@Observes HeaderStopEvent event) {
        if (event.getContext().equals(this.header)) {
            ((ServerManagementService)this.service.call()).stopContainers((Map)this.getSelectedItems().getK2());
        }
    }

    void onHeaderDelete(@Observes HeaderDeleteEvent event) {
        if (event.getContext().equals(this.header)) {
            final Pair<Map<String, String>, Map<String, List<String>>> value = this.getSelectedItems();
            this.view.confirmDeleteOperation(((Map)value.getK1()).values(), ((Map)value.getK2()).values(), new Command(){

                public void execute() {
                    ((ServerManagementService)ServerManagementBrowserPresenter.this.service.call()).deleteOp(new ArrayList(((Map)value.getK1()).keySet()), (Map)value.getK2());
                }
            });
        }
    }

    void onServerConnected(@Observes ServerConnected event) {
        this.loadServer((ServerRef)event.getServer());
    }

    void onServerError(@Observes ServerOnError event) {
        this.loadServer(event.getServer());
    }

    void onContainerCreated(@Observes ContainerCreated event) {
        this.loadContainer(event.getContainer(), ContainerStatus.STARTED);
    }

    void onServerDeleted(@Observes ServerDeleted event) {
        this.removeServer(event.getServerId());
    }

    void onContainerDeleted(@Observes ContainerDeleted event) {
        this.removeContainer(event.getServerId(), event.getContainerId());
    }

    private void loadServers(Collection<ServerRef> executionServers) {
        this.view.cleanup();
        for (BoxPresenter container : this.containers.values()) {
            this.beanManager.destroyBean((Object)container);
        }
        this.containers.clear();
        for (ServerRef executionServer : executionServers) {
            this.loadServer(executionServer);
        }
    }

    private void loadServer(ServerRef executionServerRef) {
        if (!this.containers.containsKey(executionServerRef)) {
            this.view.addBox(this.newContainer(executionServerRef));
        }
        for (ContainerRef containerRef : executionServerRef.getContainersRef()) {
            this.loadContainer(containerRef, executionServerRef.getStatus());
        }
    }

    private void loadContainer(ContainerRef container, ContainerStatus serverStatus) {
        if (serverStatus.equals((Object)ContainerStatus.ERROR)) {
            container.setStatus(ContainerStatus.ERROR);
        }
        if (this.containers.containsKey(container)) {
            return;
        }
        BoxPresenter serverContainer = null;
        for (Map.Entry<Object, BoxPresenter> entry : this.containers.entrySet()) {
            if (!(entry.getKey() instanceof ServerRef) || !((ServerRef)entry.getKey()).getId().equals(container.getServerId())) continue;
            serverContainer = entry.getValue();
            break;
        }
        if (serverContainer != null) {
            this.view.addBox(this.newContainer(container), serverContainer);
        }
    }

    private void removeContainer(String serverId, String containerId) {
        Object ref = null;
        for (Map.Entry<Object, BoxPresenter> entry : this.containers.entrySet()) {
            if (!(entry.getKey() instanceof ContainerRef) || !((ContainerRef)entry.getKey()).getServerId().equals(serverId) || !((ContainerRef)entry.getKey()).getId().equals(containerId)) continue;
            ref = entry.getKey();
            this.view.removeBox(entry.getValue());
            break;
        }
        if (ref != null) {
            this.destroyBoxPresenter(ref);
        }
    }

    private void removeServer(String serverId) {
        ArrayList<Object> refs = new ArrayList<Object>();
        for (Map.Entry<Object, BoxPresenter> entry : this.containers.entrySet()) {
            if ((!(entry.getKey() instanceof ServerRef) || !((ServerRef)entry.getKey()).getId().equals(serverId)) && (!(entry.getKey() instanceof ContainerRef) || !((ContainerRef)entry.getKey()).getServerId().equals(serverId))) continue;
            this.view.removeBox(entry.getValue());
            refs.add(entry.getKey());
        }
        if (!refs.isEmpty()) {
            for (Map.Entry<Object, BoxPresenter> entry : refs) {
                this.destroyBoxPresenter(entry);
            }
        }
    }

    private void destroyBoxPresenter(Object ref) {
        BoxPresenter presenter = this.containers.remove(ref);
        presenter.select(false);
        this.beanManager.destroyBean((Object)presenter);
    }

    private BoxPresenter newContainer(Object container) {
        final BoxPresenter boxPresenter = (BoxPresenter)this.beanManager.lookupBean(BoxPresenter.class, new Annotation[0]).getInstance();
        this.containers.put(container, boxPresenter);
        boxPresenter.setOnDeselect(new Command(){

            public void execute() {
                boolean hasServerSelected = false;
                boolean hasContainerSelected = false;
                boolean hasStartedContainerSelected = false;
                boolean hasStoppedContainerSelected = false;
                for (BoxPresenter container : ServerManagementBrowserPresenter.this.containers.values()) {
                    if (container.isSelected()) {
                        if (container.getType().equals((Object)BoxType.SERVER)) {
                            hasServerSelected = true;
                        } else if (container.getType().equals((Object)BoxType.CONTAINER)) {
                            hasContainerSelected = true;
                            if (container.getStatus().equals((Object)ContainerStatus.STARTED)) {
                                hasStartedContainerSelected = true;
                            } else if (container.getStatus().equals((Object)ContainerStatus.STOPPED)) {
                                hasStoppedContainerSelected = true;
                            }
                        }
                    }
                    if (!hasServerSelected || !hasStartedContainerSelected || !hasStoppedContainerSelected) continue;
                    break;
                }
                if (hasContainerSelected) {
                    ServerManagementBrowserPresenter.this.header.displayDeleteContainer();
                } else {
                    ServerManagementBrowserPresenter.this.header.hideDeleteContainer();
                }
                if (hasStartedContainerSelected) {
                    ServerManagementBrowserPresenter.this.header.displayStopContainer();
                } else {
                    ServerManagementBrowserPresenter.this.header.hideStopContainer();
                }
                if (hasStoppedContainerSelected) {
                    ServerManagementBrowserPresenter.this.header.displayStartContainer();
                } else {
                    ServerManagementBrowserPresenter.this.header.hideStartContainer();
                }
            }
        });
        if (container instanceof ContainerRef) {
            boxPresenter.setOnSelect(new Command(){

                public void execute() {
                    ServerManagementBrowserPresenter.this.header.displayDeleteContainer();
                    if (boxPresenter.getStatus().equals((Object)ContainerStatus.STARTED)) {
                        ServerManagementBrowserPresenter.this.header.displayStopContainer();
                        ServerManagementBrowserPresenter.this.header.hideStartContainer();
                    } else if (boxPresenter.getStatus().equals((Object)ContainerStatus.STOPPED)) {
                        ServerManagementBrowserPresenter.this.header.displayStartContainer();
                        ServerManagementBrowserPresenter.this.header.hideStopContainer();
                    } else if (boxPresenter.getStatus().equals((Object)ContainerStatus.ERROR)) {
                        ServerManagementBrowserPresenter.this.header.hideStartContainer();
                        ServerManagementBrowserPresenter.this.header.hideStopContainer();
                    }
                }
            });
            boxPresenter.setup((ContainerRef)container);
        } else if (container instanceof ServerRef) {
            boxPresenter.setOnSelect(new Command(){

                public void execute() {
                    ServerManagementBrowserPresenter.this.header.displayDeleteContainer();
                }
            });
            boxPresenter.setup((ServerRef)container);
        }
        return boxPresenter;
    }

    private Pair<Map<String, String>, Map<String, List<String>>> getSelectedItems() {
        HashMap<String, String> serverNames = new HashMap<String, String>();
        HashMap container2delete = new HashMap();
        for (Map.Entry<Object, BoxPresenter> container : this.containers.entrySet()) {
            if (!container.getValue().isSelected()) continue;
            if (container.getKey() instanceof ServerRef && ((ServerRef)container.getKey()).getConnectionType().equals((Object)ConnectionType.REMOTE)) {
                serverNames.put(((ServerRef)container.getKey()).getId(), ((ServerRef)container.getKey()).getName());
                continue;
            }
            if (!(container.getKey() instanceof ContainerRef)) continue;
            ContainerRef simpleContainer = (ContainerRef)container.getKey();
            if (!container2delete.containsKey(simpleContainer.getServerId())) {
                container2delete.put(simpleContainer.getServerId(), new ArrayList());
            }
            ((List)container2delete.get(simpleContainer.getServerId())).add(simpleContainer.getId());
        }
        return Pair.newPair(serverNames, container2delete);
    }

    public static interface View
    extends IsWidget {
        public void setHeader(HeaderPresenter var1);

        public void addBox(BoxPresenter var1);

        public void addBox(BoxPresenter var1, BoxPresenter var2);

        public void removeBox(BoxPresenter var1);

        public void cleanup();

        public void confirmDeleteOperation(Collection<String> var1, Collection<List<String>> var2, Command var3);
    }
}

