/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client;

import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.screens.server.management.client.ServerManagementBrowserPresenter;
import org.kie.workbench.common.screens.server.management.client.box.BoxPresenter;
import org.kie.workbench.common.screens.server.management.client.header.HeaderPresenter;
import org.kie.workbench.common.screens.server.management.client.resources.i18n.Constants;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.mvp.Command;

@Dependent
public class ServerManagementBrowserView
extends Composite
implements ServerManagementBrowserPresenter.View {
    private final FlowPanel panel = new FlowPanel();
    private HeaderPresenter header = null;

    @PostConstruct
    public void setup() {
        this.initWidget((Widget)this.panel);
        this.panel.getElement().getStyle().setProperty("minWidth", "550px");
    }

    @Override
    public void setHeader(HeaderPresenter header) {
        if (this.header == null) {
            this.header = header;
            this.panel.getElement().getStyle().setPaddingLeft(20.0, Style.Unit.PX);
            this.panel.getElement().getStyle().setPaddingRight(20.0, Style.Unit.PX);
            this.panel.add((IsWidget)header.getView());
        }
    }

    @Override
    public void addBox(BoxPresenter container) {
        this.panel.add((IsWidget)container.getView());
    }

    @Override
    public void addBox(BoxPresenter container, BoxPresenter parentContainer) {
        this.panel.insert((IsWidget)container.getView(), this.panel.getWidgetIndex((IsWidget)parentContainer.getView()) + 1);
    }

    @Override
    public void removeBox(BoxPresenter value) {
        this.panel.remove((IsWidget)value.getView());
    }

    @Override
    public void cleanup() {
        this.panel.clear();
        if (this.header != null) {
            this.panel.add((IsWidget)this.header.getView());
        }
    }

    @Override
    public void confirmDeleteOperation(Collection<String> serverNames, Collection<List<String>> container2delete, final Command onConfirm) {
        YesNoCancelPopup.newYesNoCancelPopup((String)"Delete", (String)this.buildMessage(serverNames, container2delete), (Command)new Command(){

            public void execute() {
                onConfirm.execute();
            }
        }, (String)CommonConstants.INSTANCE.YES(), (ButtonType)ButtonType.DANGER, (IconType)IconType.EXCLAMATION_SIGN, (Command)new Command(){

            public void execute() {
            }
        }, (String)CommonConstants.INSTANCE.NO(), (ButtonType)ButtonType.DEFAULT, null, null, null, null, null).show();
    }

    private String buildMessage(Collection<String> serverNames, Collection<List<String>> container2delete) {
        StringBuilder sb = new StringBuilder();
        if (!serverNames.isEmpty()) {
            sb.append(Constants.INSTANCE.confirm_delete_servers()).append("<br/>");
            for (String string : serverNames) {
                sb.append(string).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(".");
        }
        if (!container2delete.isEmpty()) {
            if (serverNames.isEmpty()) {
                sb.append(Constants.INSTANCE.confirm_delete_containers()).append("<br/>");
            } else {
                sb.append("<br/>").append(Constants.INSTANCE.and_containers()).append("<br/>");
            }
            for (List list : container2delete) {
                for (String s : list) {
                    sb.append(s).append(", ");
                }
            }
            sb.setLength(sb.length() - 2);
            sb.append(".");
        }
        return sb.toString();
    }
}

