/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.artifact;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.server.management.client.artifact.DependencyListWidgetPresenter;
import org.kie.workbench.common.screens.server.management.client.events.DependencyPathSelectedEvent;
import org.kie.workbench.common.screens.server.management.service.ServerManagementService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchPopup;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchPopup(identifier="NewContainerForm")
public class NewContainerFormPresenter {
    private final View view;
    private final PlaceManager placeManager;
    private final Caller<M2RepoService> m2RepoService;
    private final Caller<ServerManagementService> service;
    private final DependencyListWidgetPresenter dependencyListWidgetPresenter;
    private PlaceRequest place;
    private String serverId;
    private String endpoint;
    private String containerName;
    public String groupId;
    public String artifactId;
    public String version;

    @Inject
    public NewContainerFormPresenter(View view, PlaceManager placeManager, Caller<M2RepoService> m2RepoService, Caller<ServerManagementService> service, DependencyListWidgetPresenter dependencyListWidgetPresenter) {
        this.view = view;
        this.placeManager = placeManager;
        this.m2RepoService = m2RepoService;
        this.service = service;
        this.dependencyListWidgetPresenter = dependencyListWidgetPresenter;
        this.view.init(this);
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
        this.serverId = place.getParameter("serverId", null);
        this.setEndpoint(this.serverId + "/containers/");
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Create Container...";
    }

    private void setEndpoint(String value) {
        this.endpoint = value;
        this.view.setEndpoint(this.endpoint);
    }

    public void setContainerName(String value) {
        this.containerName = value;
        this.setEndpoint(this.serverId + "/containers/" + this.containerName);
    }

    public void createContainer(String containerName, String groupId, String artifactId, String version) {
        this.setContainerName(containerName);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        ((ServerManagementService)this.service.call()).createContainer(this.serverId, this.containerName, new GAV(this.groupId, this.artifactId, this.version));
    }

    void onDependencyPathSelectedEvent(@Observes DependencyPathSelectedEvent event) {
        if (event.getContext().equals(this.dependencyListWidgetPresenter)) {
            ((M2RepoService)this.m2RepoService.call((RemoteCallback)new RemoteCallback<GAV>(){

                public void callback(GAV gav) {
                    NewContainerFormPresenter.this.groupId = gav.getGroupId();
                    NewContainerFormPresenter.this.artifactId = gav.getArtifactId();
                    NewContainerFormPresenter.this.version = gav.getVersion();
                    NewContainerFormPresenter.this.view.setGroupId(NewContainerFormPresenter.this.groupId);
                    NewContainerFormPresenter.this.view.setAtifactId(NewContainerFormPresenter.this.artifactId);
                    NewContainerFormPresenter.this.view.setVersion(NewContainerFormPresenter.this.version);
                }
            })).loadGAVFromJar(event.getPath());
        }
    }

    public void close() {
        this.placeManager.forceClosePlace(this.place);
    }

    DependencyListWidgetPresenter getDependencyListWidgetPresenter() {
        return this.dependencyListWidgetPresenter;
    }

    String getServerId() {
        return this.serverId;
    }

    String getEndpoint() {
        return this.endpoint;
    }

    String getContainerName() {
        return this.containerName;
    }

    String getGroupId() {
        return this.groupId;
    }

    String getArtifactId() {
        return this.artifactId;
    }

    String getVersion() {
        return this.version;
    }

    public static interface View
    extends UberView<NewContainerFormPresenter> {
        public void setGroupId(String var1);

        public void setAtifactId(String var1);

        public void setVersion(String var1);

        public void setEndpoint(String var1);
    }
}

