/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.box;

import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.GAV;
import org.kie.workbench.common.screens.server.management.client.box.BoxType;
import org.kie.workbench.common.screens.server.management.client.events.ContainerInfoUpdateEvent;
import org.kie.workbench.common.screens.server.management.events.ContainerStarted;
import org.kie.workbench.common.screens.server.management.events.ContainerStopped;
import org.kie.workbench.common.screens.server.management.events.ContainerUpdated;
import org.kie.workbench.common.screens.server.management.events.ServerConnected;
import org.kie.workbench.common.screens.server.management.events.ServerDisconnected;
import org.kie.workbench.common.screens.server.management.events.ServerOnError;
import org.kie.workbench.common.screens.server.management.model.Container;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ServerRef;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class BoxPresenter {
    private View view;
    private PlaceManager placeManager;
    private Event<ContainerInfoUpdateEvent> containerInfoEvent;
    private String name = null;
    private String serverId;
    private ContainerStatus status;
    private boolean isVisible = true;
    private boolean isSelected = false;
    private String description;
    private BoxType type;
    private boolean supportsOpenCommand = false;
    private Command onSelect = new Command(){

        public void execute() {
        }
    };
    private Command onDeselect = new Command(){

        public void execute() {
        }
    };

    @Inject
    public BoxPresenter(View view, PlaceManager placeManager, Event<ContainerInfoUpdateEvent> containerInfoEvent) {
        this.view = view;
        this.placeManager = placeManager;
        this.containerInfoEvent = containerInfoEvent;
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void setup(ServerRef server) {
        this.serverId = server.getId();
        this.name = server.getName();
        this.status = server.getStatus();
        this.type = BoxType.SERVER;
        this.description = this.buildDescription(server.getProperties());
        this.supportsOpenCommand = false;
        this.setupView();
    }

    private String buildDescription(Map<String, String> properties) {
        if (properties.containsKey("version")) {
            return "Server v." + properties.get("version");
        }
        return "Unknown Server";
    }

    public void setup(ContainerRef container) {
        this.serverId = container.getServerId();
        this.name = container.getId();
        this.status = container.getStatus();
        this.type = BoxType.CONTAINER;
        this.description = container instanceof Container ? this.buildDescription(container.getReleasedId(), ((Container)container).getResolvedReleasedId()) : this.buildDescription(container.getReleasedId());
        this.supportsOpenCommand = true;
        this.setupView();
    }

    private String buildDescription(GAV releasedId) {
        return this.buildDescription(releasedId, null);
    }

    private String buildDescription(GAV releasedId, GAV resolvedReleasedId) {
        if (releasedId != null) {
            if (resolvedReleasedId == null || releasedId.equals((Object)resolvedReleasedId)) {
                return releasedId.getGroupId() + ":" + releasedId.getArtifactId() + "-" + releasedId.getVersion();
            }
            return resolvedReleasedId.getGroupId() + ":" + resolvedReleasedId.getArtifactId() + "-" + resolvedReleasedId.getVersion() + "(" + releasedId.getGroupId() + ":" + releasedId.getArtifactId() + "-" + releasedId.getVersion() + ")";
        }
        return "Unknown Container";
    }

    private void setupView() {
        this.view.setup(this.type);
        this.updateView();
    }

    public void select(boolean selected) {
        this.isSelected = selected;
        if (selected) {
            this.view.onSelect();
        } else {
            this.view.onDeselect();
        }
    }

    private void show() {
        this.view.show();
        this.isVisible = true;
    }

    private void hide() {
        this.view.hide();
        this.isVisible = false;
        this.isSelected = false;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public ContainerStatus getStatus() {
        return this.status;
    }

    public void setOnSelect(Command command) {
        this.onSelect = command;
    }

    public void setOnDeselect(Command command) {
        this.onDeselect = command;
    }

    public boolean isSelected() {
        return this.isVisible && this.isSelected;
    }

    public BoxType getType() {
        return this.type;
    }

    public boolean supportsOpenCommand() {
        return this.supportsOpenCommand;
    }

    public void openBoxInfo() {
        if (this.supportsOpenCommand()) {
            this.placeManager.goTo("ContainerInfo");
            this.containerInfoEvent.fire((Object)new ContainerInfoUpdateEvent(this.serverId, this.name));
        }
    }

    public void openAddScreen() {
        if (this.enableAddAction()) {
            this.placeManager.goTo(new DefaultPlaceRequest("NewContainerForm").addParameter("serverId", this.serverId));
        }
    }

    public boolean enableAddAction() {
        return this.type.equals((Object)BoxType.SERVER) && this.status.equals((Object)ContainerStatus.STARTED);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void onUnSelect() {
        this.isSelected = false;
        this.onDeselect.execute();
    }

    public void onSelect() {
        this.isSelected = true;
        this.onSelect.execute();
    }

    public void filter(String filter) {
        if (filter == null || filter.trim().isEmpty() || this.name.toLowerCase().contains(filter.trim().toLowerCase())) {
            this.show();
        } else {
            this.hide();
        }
    }

    void onServerConnected(@Observes ServerConnected connected) {
        if (this.serverId.equals(connected.getServer().getId())) {
            if (this.type.equals((Object)BoxType.SERVER)) {
                this.status = connected.getServer().getStatus();
            } else {
                for (ContainerRef containerRef : connected.getServer().getContainersRef()) {
                    if (!containerRef.getId().equals(this.getName())) continue;
                    this.status = containerRef.getStatus();
                    break;
                }
            }
            this.updateView();
        }
    }

    void onServerDisconnected(@Observes ServerDisconnected disconnected) {
        if (this.serverId.equals(disconnected.getServer().getId())) {
            if (this.type.equals((Object)BoxType.SERVER)) {
                this.status = disconnected.getServer().getStatus();
            } else {
                for (ContainerRef containerRef : disconnected.getServer().getContainersRef()) {
                    if (!containerRef.getId().equals(this.getName())) continue;
                    if (disconnected.getServer().getStatus().equals((Object)ContainerStatus.STOPPED)) {
                        this.status = disconnected.getServer().getStatus();
                        break;
                    }
                    this.status = containerRef.getStatus();
                    break;
                }
            }
            this.updateView();
        }
    }

    private void updateView() {
        this.view.setName(this.name);
        this.view.setDescription(this.description);
        this.view.setStatus(this.status);
        if (this.enableAddAction()) {
            this.view.enableAddAction();
        } else {
            this.view.disableAddAction();
        }
        if (this.supportsOpenCommand()) {
            this.view.enableOpenAction();
        } else {
            this.view.disableOpenAction();
        }
    }

    void onServerOnError(@Observes ServerOnError serverOnError) {
        if (this.serverId.equals(serverOnError.getServer().getId())) {
            this.status = serverOnError.getServer().getStatus();
            this.updateView();
        }
    }

    void onContainerStopped(@Observes ContainerStopped containerStoped) {
        if (this.name.equals(containerStoped.getContainer().getId()) && this.serverId.equals(containerStoped.getContainer().getServerId())) {
            this.status = containerStoped.getContainer().getStatus();
            this.updateView();
        }
    }

    void onContainerStarted(@Observes ContainerStarted containerStarted) {
        if (this.name.equals(containerStarted.getContainer().getId()) && this.serverId.equals(containerStarted.getContainer().getServerId())) {
            this.status = containerStarted.getContainer().getStatus();
            this.description = this.buildDescription(containerStarted.getContainer().getReleasedId(), containerStarted.getContainer().getResolvedReleasedId());
            this.updateView();
        }
    }

    void onContainerUpdated(@Observes ContainerUpdated containerUpdated) {
        if (this.name.equals(containerUpdated.getContainer().getId()) && this.serverId.equals(containerUpdated.getContainer().getServerId())) {
            this.status = containerUpdated.getContainer().getStatus();
            this.description = this.buildDescription(containerUpdated.getContainer().getReleasedId(), containerUpdated.getContainer().getResolvedReleasedId());
            this.updateView();
        }
    }

    public static interface View
    extends UberView<BoxPresenter> {
        public void setup(BoxType var1);

        public void onSelect();

        public void onDeselect();

        public void setStatus(ContainerStatus var1);

        public void show();

        public void hide();

        public void setName(String var1);

        public void setDescription(String var1);

        public void enableAddAction();

        public void disableAddAction();

        public void enableOpenAction();

        public void disableOpenAction();
    }
}

