/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.box;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.screens.server.management.client.box.BoxPresenter;
import org.kie.workbench.common.screens.server.management.client.box.BoxType;
import org.kie.workbench.common.screens.server.management.client.resources.ContainerResources;
import org.kie.workbench.common.screens.server.management.client.util.ContainerStatusUtil;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class BoxView
extends Composite
implements BoxPresenter.View {
    private static ContainerViewBinder uiBinder = (ContainerViewBinder)GWT.create(ContainerViewBinder.class);
    @UiField
    DivElement box;
    @UiField
    Element notSelected;
    @UiField
    Element selected;
    @UiField
    Element status;
    @UiField
    AnchorElement containerName;
    @UiField
    SpanElement complement;
    @UiField
    UListElement listOfServices;
    @UiField
    DivElement actions;
    @UiField
    Element addAction;
    @UiField
    Element openAction;
    private BoxPresenter presenter;

    public BoxView() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(BoxPresenter presenter) {
        this.presenter = (BoxPresenter)PortablePreconditions.checkNotNull((String)"presenter", (Object)presenter);
    }

    @Override
    public void setup(BoxType type) {
        this.selected.setTitle("Selected");
        this.notSelected.setTitle("Not selected");
        this.addAction.setTitle("New Container");
        this.openAction.setTitle("Open");
        DOM.sinkEvents((Element)this.selected, (int)1);
        DOM.setEventListener((Element)this.selected, (EventListener)new EventListener(){

            public void onBrowserEvent(Event event) {
                BoxView.this.onDeselect();
            }
        });
        DOM.sinkEvents((Element)this.notSelected, (int)1);
        DOM.setEventListener((Element)this.notSelected, (EventListener)new EventListener(){

            public void onBrowserEvent(Event event) {
                BoxView.this.onSelect();
            }
        });
        DOM.sinkEvents((Element)this.addAction, (int)1);
        DOM.setEventListener((Element)this.addAction, (EventListener)new EventListener(){

            public void onBrowserEvent(Event event) {
                BoxView.this.addAction();
            }
        });
        DOM.sinkEvents((Element)this.openAction, (int)1);
        DOM.setEventListener((Element)this.openAction, (EventListener)new EventListener(){

            public void onBrowserEvent(Event event) {
                BoxView.this.openAction();
            }
        });
        if (type.equals((Object)BoxType.CONTAINER)) {
            this.box.addClassName(ContainerResources.INSTANCE.CSS().childContainer());
        } else {
            this.box.removeClassName(ContainerResources.INSTANCE.CSS().childContainer());
        }
    }

    private void openAction() {
        this.presenter.openBoxInfo();
    }

    private void addAction() {
        this.presenter.openAddScreen();
    }

    @Override
    public void enableAddAction() {
        this.addAction.getStyle().clearDisplay();
    }

    @Override
    public void disableAddAction() {
        this.addAction.getStyle().setDisplay(Style.Display.NONE);
    }

    @Override
    public void enableOpenAction() {
        this.openAction.getStyle().clearDisplay();
    }

    @Override
    public void disableOpenAction() {
        this.openAction.getStyle().setDisplay(Style.Display.NONE);
    }

    @Override
    public void onSelect() {
        this.notSelected.getStyle().setDisplay(Style.Display.NONE);
        this.selected.getStyle().clearDisplay();
        this.box.addClassName(ContainerResources.INSTANCE.CSS().selected());
        this.presenter.onSelect();
    }

    @Override
    public void onDeselect() {
        this.selected.getStyle().setDisplay(Style.Display.NONE);
        this.notSelected.getStyle().clearDisplay();
        this.box.removeClassName(ContainerResources.INSTANCE.CSS().selected());
        this.presenter.onUnSelect();
    }

    @Override
    public void setStatus(ContainerStatus status) {
        ContainerStatusUtil.setupStatus(this.status, status);
    }

    @Override
    public void show() {
        this.box.getStyle().clearDisplay();
    }

    @Override
    public void hide() {
        this.box.getStyle().setDisplay(Style.Display.NONE);
        this.onDeselect();
    }

    @Override
    public void setName(String value) {
        this.containerName.setInnerText(value);
    }

    @Override
    public void setDescription(String value) {
        this.complement.setInnerText(value);
    }

    static interface ContainerViewBinder
    extends UiBinder<Widget, BoxView> {
    }
}

