/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.container;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.GAV;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.server.management.client.events.ContainerInfoUpdateEvent;
import org.kie.workbench.common.screens.server.management.events.ContainerDeleted;
import org.kie.workbench.common.screens.server.management.events.ContainerStarted;
import org.kie.workbench.common.screens.server.management.events.ContainerStopped;
import org.kie.workbench.common.screens.server.management.events.ContainerUpdated;
import org.kie.workbench.common.screens.server.management.events.ServerConnected;
import org.kie.workbench.common.screens.server.management.events.ServerDeleted;
import org.kie.workbench.common.screens.server.management.events.ServerDisconnected;
import org.kie.workbench.common.screens.server.management.events.ServerOnError;
import org.kie.workbench.common.screens.server.management.model.Container;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ScannerStatus;
import org.kie.workbench.common.screens.server.management.model.ServerInstanceRef;
import org.kie.workbench.common.screens.server.management.model.impl.ScannerOperationResult;
import org.kie.workbench.common.screens.server.management.service.ServerManagementService;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
@WorkbenchScreen(identifier="ContainerInfo", preferredWidth=500)
public class ContainerInfoPresenter {
    private final View view;
    private final PlaceManager placeManager;
    private final Caller<ServerManagementService> service;
    private final Event<NotificationEvent> notification;
    private final Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    private PlaceRequest placeRequest;
    private boolean isClosed;
    private String serverId;
    private String containerId;
    private String pollInterval;
    private ScannerStatus scannerStatus;
    private ContainerStatus status;
    private String groupId;
    private String artifactId;
    private String version;
    private String resolvedGroupId;
    private String resolvedArtifactId;
    private String resolvedVersion;
    private List<ServerInstanceRef> endpoint;
    private State startScannerState;
    private State stopScannerState;
    private State scanNowState;
    private State upgradeState;

    @Inject
    public ContainerInfoPresenter(View view, PlaceManager placeManager, Caller<ServerManagementService> service, Event<NotificationEvent> notification, Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent) {
        this.view = view;
        this.placeManager = placeManager;
        this.service = service;
        this.notification = notification;
        this.changeTitleWidgetEvent = changeTitleWidgetEvent;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
    }

    @OnOpen
    public void onOpen() {
        this.isClosed = false;
    }

    @OnClose
    public void onClose() {
        this.isClosed = true;
        this.cleanup();
    }

    private void cleanup() {
        this.status = null;
        this.scannerStatus = null;
        this.resolvedVersion = "";
        this.resolvedArtifactId = "";
        this.resolvedGroupId = "";
        this.version = "";
        this.artifactId = "";
        this.groupId = "";
        this.pollInterval = "";
        this.containerId = "";
        this.serverId = "";
        this.endpoint = new ArrayList<ServerInstanceRef>();
        this.view.cleanup();
    }

    void onContainerInfo(@Observes ContainerInfoUpdateEvent containerInfoUpdateEvent) {
        if (this.isClosed) {
            return;
        }
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, "Container Info [" + containerInfoUpdateEvent.getContainerId() + "]", null));
        this.serverId = containerInfoUpdateEvent.getServerId();
        this.containerId = containerInfoUpdateEvent.getContainerId();
        this.view.cleanup();
        ((ServerManagementService)this.service.call((RemoteCallback)new RemoteCallback<Container>(){

            public void callback(Container response) {
                ContainerInfoPresenter.this.update((ContainerRef)response);
            }
        })).getContainerInfo(containerInfoUpdateEvent.getServerId(), containerInfoUpdateEvent.getContainerId());
    }

    private void update(ContainerRef container) {
        this.status = container.getStatus();
        this.scannerStatus = container.getScannerStatus();
        this.pollInterval = container.getPollInterval() != null ? String.valueOf(container.getPollInterval()) : "";
        if (container.getReleasedId() != null) {
            this.groupId = container.getReleasedId().getGroupId();
            this.artifactId = container.getReleasedId().getArtifactId();
            this.version = container.getReleasedId().getVersion();
        } else {
            this.version = "";
            this.artifactId = "";
            this.groupId = "";
        }
        if (container.getManagedServers() != null) {
            this.endpoint = container.getManagedServers();
        }
        if (container instanceof Container && ((Container)container).getResolvedReleasedId() != null) {
            this.resolvedGroupId = ((Container)container).getResolvedReleasedId().getGroupId();
            this.resolvedArtifactId = ((Container)container).getResolvedReleasedId().getArtifactId();
            this.resolvedVersion = ((Container)container).getResolvedReleasedId().getVersion();
        } else {
            this.resolvedVersion = "";
            this.resolvedArtifactId = "";
            this.resolvedGroupId = "";
        }
        if (this.status.equals((Object)ContainerStatus.STARTED)) {
            this.startScannerState = State.ENABLED;
            this.stopScannerState = State.ENABLED;
            this.scanNowState = State.ENABLED;
            this.upgradeState = State.ENABLED;
        } else {
            this.resolvedVersion = "";
            this.resolvedArtifactId = "";
            this.resolvedGroupId = "";
            this.startScannerState = State.DISABLED;
            this.stopScannerState = State.DISABLED;
            this.scanNowState = State.DISABLED;
            this.upgradeState = State.DISABLED;
        }
        this.setScannerStatus();
        this.updateView();
    }

    private void updateView() {
        this.view.setStatus(this.status);
        this.view.setStartScannerState(this.startScannerState);
        this.view.setStopScannerState(this.stopScannerState);
        this.view.setScanNowState(this.scanNowState);
        this.view.setUpgradeState(this.upgradeState);
        this.updateViewScannerStatus();
        this.view.setInterval(this.pollInterval);
        this.view.setGroupId(this.groupId);
        this.view.setArtifactId(this.artifactId);
        this.view.setVersion(this.version);
        this.view.setResolvedGroupId(this.resolvedGroupId);
        this.view.setResolvedArtifactId(this.resolvedArtifactId);
        this.view.setResolvedVersion(this.resolvedVersion);
        this.view.setEndpoint(this.endpoint);
    }

    private void setScannerStatus() {
        if (this.scannerStatus == null) {
            this.scannerStatus = ScannerStatus.UNKNOWN;
        }
        switch (this.scannerStatus) {
            case CREATED: 
            case STARTED: 
            case SCANNING: {
                this.startScannerState = State.DISABLED;
                this.stopScannerState = State.ENABLED;
                this.scanNowState = State.DISABLED;
                this.upgradeState = State.DISABLED;
                break;
            }
            case STOPPED: 
            case DISPOSED: 
            case ERROR: {
                this.startScannerState = State.ENABLED;
                this.stopScannerState = State.DISABLED;
                this.scanNowState = State.ENABLED;
                this.upgradeState = State.ENABLED;
                break;
            }
            default: {
                this.startScannerState = State.ENABLED;
                this.stopScannerState = State.DISABLED;
                this.scanNowState = State.ENABLED;
                this.upgradeState = State.ENABLED;
            }
        }
    }

    void updateViewScannerStatus() {
        this.view.setStartScannerState(this.startScannerState);
        this.view.setStopScannerState(this.stopScannerState);
        this.view.setScanNowState(this.scanNowState);
    }

    void onServerConnected(@Observes ServerConnected event) {
        if (this.isClosed) {
            return;
        }
        if (event.getServer().getId().equals(this.serverId)) {
            ContainerRef ref = event.getServer().getContainerRef(this.containerId);
            if (ref == null) {
                this.close();
                return;
            }
            this.update(ref);
        }
    }

    void onServerDisconnected(@Observes ServerDisconnected event) {
        if (this.isClosed) {
            return;
        }
        if (event.getServer().getId().equals(this.serverId)) {
            ContainerRef ref = event.getServer().getContainerRef(this.containerId);
            if (ref == null) {
                this.close();
                return;
            }
            this.update(ref);
        }
    }

    void onContainerUpdated(@Observes ContainerUpdated event) {
        if (this.isClosed) {
            return;
        }
        if (event.getContainer().getServerId().equals(this.serverId) && event.getContainer().getId().equals(this.containerId)) {
            this.update((ContainerRef)event.getContainer());
        }
    }

    void onContainerStarted(@Observes ContainerStarted event) {
        if (this.isClosed) {
            return;
        }
        if (event.getContainer().getServerId().equals(this.serverId) && event.getContainer().getId().equals(this.containerId)) {
            this.update((ContainerRef)event.getContainer());
        }
    }

    void onContainerStopped(@Observes ContainerStopped event) {
        if (this.isClosed) {
            return;
        }
        if (event.getContainer().getServerId().equals(this.serverId) && event.getContainer().getId().equals(this.containerId)) {
            this.update(event.getContainer());
        }
    }

    void onServerError(@Observes ServerOnError event) {
        if (event.getServer().getId().equals(this.serverId)) {
            this.close();
        }
    }

    void onServerDeleted(@Observes ServerDeleted event) {
        if (event.getServerId().equals(this.serverId)) {
            this.close();
        }
    }

    void onContainerDeleted(@Observes ContainerDeleted event) {
        if (event.getServerId().equals(this.serverId) && event.getContainerId().equals(this.containerId)) {
            this.close();
        }
    }

    public void scanNow() {
        ((ServerManagementService)this.service.call(this.getScannerCallback())).scanNow(this.serverId, this.containerId);
    }

    public void startScanner(String interval) {
        long value;
        PortablePreconditions.checkNotEmpty((String)"interval", (String)interval);
        try {
            value = Long.valueOf(interval);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
        ((ServerManagementService)this.service.call(this.getScannerCallback())).startScanner(this.serverId, this.containerId, value);
    }

    public void stopScanner() {
        ((ServerManagementService)this.service.call(this.getScannerCallback())).stopScanner(this.serverId, this.containerId);
    }

    private RemoteCallback<ScannerOperationResult> getScannerCallback() {
        return new RemoteCallback<ScannerOperationResult>(){

            public void callback(ScannerOperationResult response) {
                if (response != null) {
                    if (response.getScannerStatus().equals((Object)ScannerStatus.ERROR) && response.getMessage() != null && !response.getMessage().trim().isEmpty()) {
                        ContainerInfoPresenter.this.notification.fire((Object)new NotificationEvent(response.getMessage(), NotificationEvent.NotificationType.ERROR));
                    }
                    ContainerInfoPresenter.this.scannerStatus = response.getScannerStatus();
                    ContainerInfoPresenter.this.setScannerStatus();
                    ContainerInfoPresenter.this.updateViewScannerStatus();
                }
            }
        };
    }

    public void upgrade(GAV releaseId) {
        PortablePreconditions.checkNotNull((String)"releaseId", (Object)releaseId);
        PortablePreconditions.checkNotEmpty((String)"releaseId.groupId", (String)releaseId.getGroupId());
        PortablePreconditions.checkNotEmpty((String)"releaseId.artifactId", (String)releaseId.getArtifactId());
        PortablePreconditions.checkNotEmpty((String)"releaseId.version", (String)releaseId.getVersion());
        ((ServerManagementService)this.service.call()).upgradeContainer(this.serverId, this.containerId, releaseId);
    }

    @DefaultPosition
    public Position getPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<Widget>(){

                    public Widget build() {
                        return ContainerInfoPresenter.this.view.getCustomMenuItem(new Command(){

                            public void execute() {
                                ContainerInfoPresenter.this.close();
                            }
                        }).asWidget();
                    }
                };
            }
        }).endMenu()).build();
    }

    void close() {
        this.placeManager.forceClosePlace("ContainerInfo");
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Container Info";
    }

    @WorkbenchPartView
    public UberView<ContainerInfoPresenter> getView() {
        return this.view;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getPollInterval() {
        return this.pollInterval;
    }

    public ScannerStatus getScannerStatus() {
        return this.scannerStatus;
    }

    public ContainerStatus getStatus() {
        return this.status;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getResolvedGroupId() {
        return this.resolvedGroupId;
    }

    public String getResolvedArtifactId() {
        return this.resolvedArtifactId;
    }

    public String getResolvedVersion() {
        return this.resolvedVersion;
    }

    public List<ServerInstanceRef> getEndpoint() {
        return this.endpoint;
    }

    public State getStartScannerState() {
        return this.startScannerState;
    }

    public State getStopScannerState() {
        return this.stopScannerState;
    }

    public State getScanNowState() {
        return this.scanNowState;
    }

    public State getUpgradeState() {
        return this.upgradeState;
    }

    public static interface View
    extends UberView<ContainerInfoPresenter> {
        public void cleanup();

        public void setStatus(ContainerStatus var1);

        public void setInterval(String var1);

        public void setGroupId(String var1);

        public void setArtifactId(String var1);

        public void setVersion(String var1);

        public void setResolvedGroupId(String var1);

        public void setResolvedArtifactId(String var1);

        public void setResolvedVersion(String var1);

        public void setEndpoint(List<ServerInstanceRef> var1);

        public void setStartScannerState(State var1);

        public void setStopScannerState(State var1);

        public void setScanNowState(State var1);

        public void setUpgradeState(State var1);

        public IsWidget getCustomMenuItem(Command var1);
    }

    public static enum State {
        ENABLED,
        DISABLED;

    }
}

