/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.container;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.CellTable;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.guvnor.common.services.project.model.GAV;
import org.kie.workbench.common.screens.server.management.client.container.ContainerInfoPresenter;
import org.kie.workbench.common.screens.server.management.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.server.management.client.util.ContainerStatusUtil;
import org.kie.workbench.common.screens.server.management.client.util.NumericTextBox;
import org.kie.workbench.common.screens.server.management.client.util.ReadOnlyTextBox;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ServerInstanceRef;
import org.uberfire.mvp.Command;

@Dependent
public class ContainerInfoView
extends Composite
implements ContainerInfoPresenter.View {
    @UiField
    Element status;
    @UiField
    ControlGroup intervalGroup;
    @UiField
    NumericTextBox interval;
    @UiField
    ControlGroup groupIdGroup;
    @UiField
    ReadOnlyTextBox groupId;
    @UiField
    ControlGroup artifactIdGroup;
    @UiField
    ReadOnlyTextBox artifactId;
    @UiField
    ControlGroup versionGroup;
    @UiField
    TextBox version;
    @UiField
    ControlGroup resolvedGroupIdGroup;
    @UiField
    ReadOnlyTextBox resolvedGroupId;
    @UiField
    ControlGroup resolvedArtifactIdGroup;
    @UiField
    ReadOnlyTextBox resolvedArtifactId;
    @UiField
    ControlGroup resolvedVersionGroup;
    @UiField
    ReadOnlyTextBox resolvedVersion;
    @UiField(provided=true)
    CellTable<ServerInstanceRef> endpointTable = new CellTable();
    private ListDataProvider<ServerInstanceRef> endpointDataProvider = new ListDataProvider();
    @UiField
    Button startScanner;
    @UiField
    Button stopScanner;
    @UiField
    Button scanNow;
    @UiField
    Button upgrade;
    private Command stopScannerActive = new Command(){

        public void execute() {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new com.google.gwt.user.client.Command(){

                public void execute() {
                    ContainerInfoView.this.stopScanner.setActive(true);
                    ContainerInfoView.this.startScanner.setActive(false);
                }
            });
        }
    };
    private Command startScannerActive = new Command(){

        public void execute() {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new com.google.gwt.user.client.Command(){

                public void execute() {
                    ContainerInfoView.this.startScanner.setActive(true);
                    ContainerInfoView.this.stopScanner.setActive(false);
                }
            });
        }
    };
    private ContainerInfoPresenter presenter;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.version.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (!ContainerInfoView.this.version.getText().trim().isEmpty()) {
                    ContainerInfoView.this.versionGroup.setType(ControlGroupType.NONE);
                }
            }
        });
        this.interval.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (!ContainerInfoView.this.interval.getText().trim().isEmpty()) {
                    ContainerInfoView.this.intervalGroup.setType(ControlGroupType.NONE);
                }
            }
        });
        this.configureEndpointTable();
    }

    public void init(ContainerInfoPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setStatus(ContainerStatus status) {
        ContainerStatusUtil.setupStatus(this.status, status);
    }

    @Override
    public void setInterval(String pollInterval) {
        this.intervalGroup.setType(ControlGroupType.NONE);
        this.interval.setText(pollInterval);
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId.setText(groupId);
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.artifactId.setText(artifactId);
    }

    @Override
    public void setVersion(String version) {
        this.version.setText(version);
    }

    @Override
    public void setResolvedGroupId(String resolvedGroupId) {
        this.resolvedGroupId.setText(resolvedGroupId);
    }

    @Override
    public void setResolvedArtifactId(String resolvedArtifactId) {
        this.resolvedArtifactId.setText(resolvedArtifactId);
    }

    @Override
    public void setResolvedVersion(String resolvedVersion) {
        this.resolvedVersion.setText(resolvedVersion);
    }

    @Override
    public void setEndpoint(List<ServerInstanceRef> endpoint) {
        this.endpointDataProvider.setList(endpoint);
    }

    @Override
    public void setStartScannerState(ContainerInfoPresenter.State state) {
        this.startScanner.setEnabled(state.equals((Object)ContainerInfoPresenter.State.ENABLED));
    }

    @Override
    public void setStopScannerState(ContainerInfoPresenter.State state) {
        this.stopScanner.setEnabled(state.equals((Object)ContainerInfoPresenter.State.ENABLED));
    }

    @Override
    public void setScanNowState(ContainerInfoPresenter.State state) {
        this.scanNow.setEnabled(state.equals((Object)ContainerInfoPresenter.State.ENABLED));
    }

    @Override
    public void setUpgradeState(ContainerInfoPresenter.State state) {
        this.upgrade.setEnabled(state.equals((Object)ContainerInfoPresenter.State.ENABLED));
    }

    @Override
    public IsWidget getCustomMenuItem(final Command onClick) {
        return new Button(){
            {
                this.setIcon(IconType.REMOVE);
                this.setTitle(Constants.INSTANCE.remove());
                this.setSize(ButtonSize.MINI);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        onClick.execute();
                    }
                });
            }
        };
    }

    @Override
    public void cleanup() {
        this.intervalGroup.setType(ControlGroupType.NONE);
        this.interval.setText("");
        this.startScanner.setEnabled(false);
        this.stopScanner.setEnabled(false);
        this.scanNow.setEnabled(false);
        this.groupId.setText("");
        this.artifactId.setText("");
        this.version.setText("");
        this.resolvedGroupId.setText("");
        this.resolvedArtifactId.setText("");
        this.resolvedVersion.setText("");
        this.endpointDataProvider.getList().clear();
        this.groupIdGroup.setType(ControlGroupType.NONE);
        this.artifactIdGroup.setType(ControlGroupType.NONE);
        this.versionGroup.setType(ControlGroupType.NONE);
    }

    @UiHandler(value={"startScanner"})
    public void startScanner(ClickEvent e) {
        if (this.startScanner.isActive()) {
            return;
        }
        try {
            this.presenter.startScanner(this.interval.getText());
        }
        catch (IllegalArgumentException ex) {
            this.intervalGroup.setType(ControlGroupType.ERROR);
            this.stopScannerActive.execute();
        }
    }

    @UiHandler(value={"stopScanner"})
    public void stopScanner(ClickEvent e) {
        if (this.stopScanner.isActive()) {
            return;
        }
        this.stopScannerActive.execute();
        this.presenter.stopScanner();
    }

    @UiHandler(value={"scanNow"})
    public void scanNow(ClickEvent e) {
        this.stopScannerActive.execute();
        this.presenter.scanNow();
    }

    @UiHandler(value={"upgrade"})
    public void upgrade(ClickEvent e) {
        try {
            this.presenter.upgrade(new GAV(this.groupId.getText(), this.artifactId.getText(), this.version.getText()));
        }
        catch (IllegalArgumentException ex) {
            this.versionGroup.setType(ControlGroupType.ERROR);
        }
    }

    private void configureEndpointTable() {
        this.endpointTable.setStriped(true);
        this.endpointTable.setCondensed(true);
        this.endpointTable.setBordered(true);
        this.endpointTable.setEmptyTableWidget((Widget)new Label(Constants.INSTANCE.no_data_defined()));
        Column<ServerInstanceRef, String> urlColumn = new Column<ServerInstanceRef, String>((Cell)new TextCell()){

            public String getValue(ServerInstanceRef item) {
                return item.getUrl();
            }
        };
        Column<ServerInstanceRef, String> statusColumn = new Column<ServerInstanceRef, String>((Cell)new TextCell()){

            public String getValue(ServerInstanceRef item) {
                return item.getStatus();
            }
        };
        this.endpointTable.addColumn((Column)urlColumn, (Header)new TextHeader(Constants.INSTANCE.endpoint()));
        this.endpointTable.addColumn((Column)statusColumn, (Header)new TextHeader(Constants.INSTANCE.status()));
        this.endpointDataProvider.addDataDisplay(this.endpointTable);
    }

    static interface Binder
    extends UiBinder<Widget, ContainerInfoView> {
    }
}

