/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.header;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.screens.server.management.client.events.HeaderClearSelectionEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderDeleteEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderFilterEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderRefreshEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderSelectAllEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderStartEvent;
import org.kie.workbench.common.screens.server.management.client.events.HeaderStopEvent;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;

@Dependent
public class HeaderPresenter {
    private final View view;
    private final Event<HeaderFilterEvent> filterEvent;
    private final Event<HeaderClearSelectionEvent> clearSelectionEvent;
    private final Event<HeaderSelectAllEvent> selectAllEvent;
    private final Event<HeaderDeleteEvent> headerDeleteEvent;
    private final Event<HeaderStopEvent> headerStopEvent;
    private final Event<HeaderStartEvent> headerStartEvent;
    private final Event<HeaderRefreshEvent> headerRefreshEvent;
    private final PlaceManager placeManager;
    private State deleteContainerState = State.DISPLAY;
    private State stopContainerState = State.DISPLAY;
    private State startContainerState = State.DISPLAY;

    @Inject
    public HeaderPresenter(View view, PlaceManager placeManager, Event<HeaderFilterEvent> filterEvent, Event<HeaderClearSelectionEvent> clearSelectionEvent, Event<HeaderSelectAllEvent> selectAllEvent, Event<HeaderDeleteEvent> headerDeleteEvent, Event<HeaderStopEvent> headerStopEvent, Event<HeaderStartEvent> headerStartEvent, Event<HeaderRefreshEvent> headerRefreshEvent) {
        this.view = view;
        this.placeManager = placeManager;
        this.filterEvent = filterEvent;
        this.clearSelectionEvent = clearSelectionEvent;
        this.selectAllEvent = selectAllEvent;
        this.headerDeleteEvent = headerDeleteEvent;
        this.headerStopEvent = headerStopEvent;
        this.headerStartEvent = headerStartEvent;
        this.headerRefreshEvent = headerRefreshEvent;
        this.view.init(this);
    }

    public void displayDeleteContainer() {
        this.deleteContainerState = State.DISPLAY;
        this.view.displayDeleteContainer();
    }

    public void displayStopContainer() {
        this.stopContainerState = State.DISPLAY;
        this.view.displayStopContainer();
    }

    public void displayStartContainer() {
        this.startContainerState = State.DISPLAY;
        this.view.displayStartContainer();
    }

    public void hideStartContainer() {
        this.startContainerState = State.HIDE;
        this.view.hideStartContainer();
    }

    public void hideStopContainer() {
        this.stopContainerState = State.HIDE;
        this.view.hideStopContainer();
    }

    public void hideDeleteContainer() {
        this.deleteContainerState = State.HIDE;
        this.view.hideDeleteContainer();
    }

    public View getView() {
        return this.view;
    }

    public void filter(String value) {
        this.filterEvent.fire((Object)new HeaderFilterEvent(this, value));
    }

    public void registerServer() {
        this.placeManager.goTo("ServerRegistryEndpoint");
    }

    public void refresh() {
        this.headerRefreshEvent.fire((Object)new HeaderRefreshEvent(this));
    }

    public void selectAll() {
        this.selectAllEvent.fire((Object)new HeaderSelectAllEvent(this));
    }

    public void clearSelection() {
        this.clearSelectionEvent.fire((Object)new HeaderClearSelectionEvent(this));
    }

    public void start() {
        if (this.startContainerState.equals((Object)State.DISPLAY)) {
            this.headerStartEvent.fire((Object)new HeaderStartEvent(this));
        }
    }

    public void stopContainer() {
        if (this.stopContainerState.equals((Object)State.DISPLAY)) {
            this.headerStopEvent.fire((Object)new HeaderStopEvent(this));
        }
    }

    public void delete() {
        if (this.deleteContainerState.equals((Object)State.DISPLAY)) {
            this.headerDeleteEvent.fire((Object)new HeaderDeleteEvent(this));
        }
    }

    public static interface View
    extends UberView<HeaderPresenter> {
        public void displayDeleteContainer();

        public void displayStopContainer();

        public void displayStartContainer();

        public void hideDeleteContainer();

        public void hideStopContainer();

        public void hideStartContainer();
    }

    static enum State {
        DISPLAY,
        HIDE;

    }
}

