/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.registry;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.server.management.service.ServerAlreadyRegisteredException;
import org.kie.workbench.common.screens.server.management.service.ServerManagementService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchPopup;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.Commands;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchPopup(identifier="ServerRegistryEndpoint")
public class ServerRegistryEndpointPresenter {
    private final View view;
    private final PlaceManager placeManager;
    private final Caller<ServerManagementService> service;
    private final ErrorPopupPresenter errorPopup;
    private PlaceRequest place;

    @Inject
    public ServerRegistryEndpointPresenter(View view, PlaceManager placeManager, Caller<ServerManagementService> service, ErrorPopupPresenter errorPopup) {
        this.view = view;
        this.placeManager = placeManager;
        this.service = service;
        this.errorPopup = errorPopup;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @WorkbenchPartView
    public UberView<ServerRegistryEndpointPresenter> getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Register Server";
    }

    public void registerServer(String id, String name, String version) {
        this.view.lockScreen();
        ((ServerManagementService)this.service.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                ServerRegistryEndpointPresenter.this.close();
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object message, Throwable throwable) {
                String errorMessage = "Can't connect to endpoint.";
                if (throwable instanceof ServerAlreadyRegisteredException) {
                    errorMessage = throwable.getMessage();
                }
                ServerRegistryEndpointPresenter.this.errorPopup.showMessage(errorMessage, Commands.DO_NOTHING, new Command(){

                    public void execute() {
                        ServerRegistryEndpointPresenter.this.view.unlockScreen();
                    }
                });
                return false;
            }
        })).registerServer(id, name, version);
    }

    public void close() {
        this.view.unlockScreen();
        this.placeManager.forceClosePlace(this.place);
    }

    public static interface View
    extends UberView<ServerRegistryEndpointPresenter> {
        public String getBaseURL();

        public void lockScreen();

        public void unlockScreen();
    }
}

