/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.registry;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.screens.server.management.client.registry.ServerRegistryEndpointPresenter;

@Dependent
public class ServerRegistryEndpointView
extends Composite
implements ServerRegistryEndpointPresenter.View {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    Button connect;
    @UiField
    Button cancel;
    @UiField
    ControlGroup versionGroup;
    @UiField
    ControlGroup nameGroup;
    @UiField
    ControlGroup idGroup;
    @UiField
    TextBox versionTextBox;
    @UiField
    TextBox idTextBox;
    @UiField
    TextBox nameTextBox;
    @UiField
    HelpInline nameHelpInline;
    @UiField
    HelpInline idHelpInline;
    @UiField
    HelpInline versionHelpInline;
    private ServerRegistryEndpointPresenter presenter;

    public ServerRegistryEndpointView() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(ServerRegistryEndpointPresenter presenter) {
        this.presenter = presenter;
        this.idTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                ServerRegistryEndpointView.this.idGroup.setType(ControlGroupType.NONE);
                ServerRegistryEndpointView.this.idHelpInline.setText("");
            }
        });
    }

    @UiHandler(value={"connect"})
    public void onConnectClick(ClickEvent e) {
        if (this.idTextBox.getText() == null || this.idTextBox.getText().trim().isEmpty()) {
            this.idGroup.setType(ControlGroupType.ERROR);
            this.idHelpInline.setText("Identifier mandatory");
            return;
        }
        this.idGroup.setType(ControlGroupType.NONE);
        if (this.nameTextBox.getText() == null || this.nameTextBox.getText().trim().isEmpty()) {
            this.nameGroup.setType(ControlGroupType.ERROR);
            this.nameHelpInline.setText("Name mandatory");
            return;
        }
        this.nameGroup.setType(ControlGroupType.NONE);
        this.presenter.registerServer(this.idTextBox.getText(), this.nameTextBox.getText(), this.versionTextBox.getText());
    }

    @Override
    public String getBaseURL() {
        return GWT.getHostPageBaseURL().replaceFirst("/" + GWT.getModuleName() + "/", "");
    }

    @Override
    public void lockScreen() {
        this.connect.setEnabled(false);
        this.cancel.setEnabled(false);
        this.idTextBox.setEnabled(false);
        this.nameTextBox.setEnabled(false);
        this.versionTextBox.setEnabled(false);
    }

    @Override
    public void unlockScreen() {
        this.connect.setEnabled(true);
        this.cancel.setEnabled(true);
        this.idTextBox.setEnabled(true);
        this.nameTextBox.setEnabled(true);
        this.versionTextBox.setEnabled(true);
    }

    @UiHandler(value={"cancel"})
    public void onCancelClick(ClickEvent e) {
        this.presenter.close();
    }

    static interface Binder
    extends UiBinder<Widget, ServerRegistryEndpointView> {
    }
}

