/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.util;

import com.google.gwt.regexp.shared.RegExp;
import java.math.BigDecimal;
import org.kie.workbench.common.screens.server.management.client.util.AbstractRestrictedEntryTextBox;

public class NumericTextBox
extends AbstractRestrictedEntryTextBox {
    private static final RegExp VALID_NUMBER = RegExp.compile((String)"(^[-]?[0-9]*\\.?[0-9]*([eE][-+]?[0-9]*)?$)");

    public NumericTextBox() {
        super(false);
    }

    public NumericTextBox(boolean allowEmptyValue) {
        super(allowEmptyValue);
    }

    @Override
    public boolean isValidValue(String value, boolean isOnFocusLost) {
        boolean isValid = VALID_NUMBER.test(value);
        if (!isValid) {
            return isValid;
        }
        if (!isOnFocusLost && "-".equals(value)) {
            return true;
        }
        try {
            BigDecimal check = new BigDecimal(value);
        }
        catch (NumberFormatException nfe) {
            isValid = "".equals(value) && this.allowEmptyValue;
        }
        return isValid;
    }
}

