/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.container.config.rules;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.events.RuleConfigUpdated;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.workbench.common.screens.server.management.client.util.State;
import org.kie.workbench.common.screens.server.management.service.RuleCapabilitiesService;
import org.slf4j.Logger;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class ContainerRulesConfigPresenter {
    private final Logger logger;
    private final View view;
    private final Caller<RuleCapabilitiesService> ruleCapabilitiesService;
    private final Event<NotificationEvent> notification;
    private ContainerSpec containerSpec;
    private String pollInterval;
    private KieScannerStatus scannerStatus;
    private State startScannerState;
    private State stopScannerState;
    private State scanNowState;
    private State upgradeState;

    @Inject
    public ContainerRulesConfigPresenter(Logger logger, View view, Caller<RuleCapabilitiesService> ruleCapabilitiesService, Event<NotificationEvent> notification) {
        this.logger = logger;
        this.view = view;
        this.ruleCapabilitiesService = ruleCapabilitiesService;
        this.notification = notification;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void setup(ContainerSpec containerSpec, RuleConfig ruleConfig) {
        this.containerSpec = (ContainerSpec)PortablePreconditions.checkNotNull((String)"containerSpec", (Object)containerSpec);
        this.setRuleConfig(ruleConfig, containerSpec.getReleasedId().getVersion());
    }

    public void setVersion(String version) {
        this.view.setVersion(version);
    }

    public void startScanner(String interval) {
        if (interval.trim().isEmpty()) {
            this.view.errorOnInterval();
            return;
        }
        this.view.disableActions();
        ((RuleCapabilitiesService)this.ruleCapabilitiesService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                ContainerRulesConfigPresenter.this.scannerStatus = KieScannerStatus.STARTED;
                ContainerRulesConfigPresenter.this.setScannerStatus();
                ContainerRulesConfigPresenter.this.updateViewState();
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                ContainerRulesConfigPresenter.this.notification.fire((Object)new NotificationEvent(ContainerRulesConfigPresenter.this.view.getStartScannerErrorMessage(), NotificationEvent.NotificationType.ERROR));
                ContainerRulesConfigPresenter.this.updateViewState();
                return false;
            }
        })).startScanner((ContainerSpecKey)this.containerSpec, (long)Integer.valueOf(PortablePreconditions.checkNotEmpty((String)"interval", (String)interval)).intValue());
    }

    public void stopScanner() {
        this.view.disableActions();
        ((RuleCapabilitiesService)this.ruleCapabilitiesService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                ContainerRulesConfigPresenter.this.scannerStatus = KieScannerStatus.STOPPED;
                ContainerRulesConfigPresenter.this.setScannerStatus();
                ContainerRulesConfigPresenter.this.updateViewState();
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                ContainerRulesConfigPresenter.this.notification.fire((Object)new NotificationEvent(ContainerRulesConfigPresenter.this.view.getStopScannerErrorMessage(), NotificationEvent.NotificationType.ERROR));
                ContainerRulesConfigPresenter.this.updateViewState();
                return false;
            }
        })).stopScanner((ContainerSpecKey)this.containerSpec);
    }

    public void scanNow() {
        this.view.disableActions();
        ((RuleCapabilitiesService)this.ruleCapabilitiesService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                ContainerRulesConfigPresenter.this.scannerStatus = KieScannerStatus.STOPPED;
                ContainerRulesConfigPresenter.this.setScannerStatus();
                ContainerRulesConfigPresenter.this.updateViewState();
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                ContainerRulesConfigPresenter.this.notification.fire((Object)new NotificationEvent(ContainerRulesConfigPresenter.this.view.getScanNowErrorMessage(), NotificationEvent.NotificationType.ERROR));
                ContainerRulesConfigPresenter.this.updateViewState();
                return false;
            }
        })).scanNow((ContainerSpecKey)this.containerSpec);
    }

    public void upgrade(String version) {
        this.view.disableActions();
        ((RuleCapabilitiesService)this.ruleCapabilitiesService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                ContainerRulesConfigPresenter.this.updateViewState();
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                ContainerRulesConfigPresenter.this.notification.fire((Object)new NotificationEvent(ContainerRulesConfigPresenter.this.view.getUpgradeErrorMessage(), NotificationEvent.NotificationType.ERROR));
                ContainerRulesConfigPresenter.this.updateViewState();
                return false;
            }
        })).upgradeContainer((ContainerSpecKey)this.containerSpec, new ReleaseId(this.containerSpec.getReleasedId().getGroupId(), this.containerSpec.getReleasedId().getArtifactId(), version));
    }

    public void onConfigUpdate(@Observes RuleConfigUpdated configUpdated) {
        if (configUpdated != null && configUpdated.getContainerSpecKey() != null && configUpdated.getContainerSpecKey().equals((Object)this.containerSpec)) {
            this.setup(this.containerSpec, configUpdated.getRuleConfig());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void onRuleConfigUpdate(@Observes RuleConfigUpdated configUpdate) {
        if (configUpdate != null && configUpdate.getRuleConfig() != null && configUpdate.getReleasedId() != null) {
            this.setRuleConfig(configUpdate.getRuleConfig(), configUpdate.getReleasedId().getVersion());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    private void setRuleConfig(RuleConfig ruleConfig, String version) {
        PortablePreconditions.checkNotNull((String)"ruleConfig", (Object)ruleConfig);
        PortablePreconditions.checkNotEmpty((String)"version", (String)version);
        this.scannerStatus = ruleConfig.getScannerStatus();
        this.pollInterval = ruleConfig.getPollInterval() != null ? String.valueOf(ruleConfig.getPollInterval()) : "";
        this.setScannerStatus();
        this.view.setContent(this.pollInterval, version, this.startScannerState, this.stopScannerState, this.scanNowState, this.upgradeState);
    }

    private void setScannerStatus() {
        if (this.scannerStatus == null) {
            this.scannerStatus = KieScannerStatus.UNKNOWN;
        }
        switch (this.scannerStatus) {
            case CREATED: 
            case STARTED: 
            case SCANNING: {
                this.startScannerState = State.DISABLED;
                this.stopScannerState = State.ENABLED;
                this.scanNowState = State.DISABLED;
                this.upgradeState = State.DISABLED;
                break;
            }
            case STOPPED: 
            case DISPOSED: {
                this.startScannerState = State.ENABLED;
                this.stopScannerState = State.DISABLED;
                this.scanNowState = State.ENABLED;
                this.upgradeState = State.ENABLED;
                break;
            }
            default: {
                this.startScannerState = State.ENABLED;
                this.stopScannerState = State.DISABLED;
                this.scanNowState = State.ENABLED;
                this.upgradeState = State.ENABLED;
            }
        }
    }

    void updateViewState() {
        this.view.setStartScannerState(this.startScannerState);
        this.view.setStopScannerState(this.stopScannerState);
        this.view.setScanNowState(this.scanNowState);
        this.view.setUpgradeState(this.upgradeState);
    }

    public static interface View
    extends UberView<ContainerRulesConfigPresenter> {
        public void setContent(String var1, String var2, State var3, State var4, State var5, State var6);

        public String getInterval();

        public String getVersion();

        public void setVersion(String var1);

        public void setStartScannerState(State var1);

        public void setStopScannerState(State var1);

        public void setScanNowState(State var1);

        public void setUpgradeState(State var1);

        public void disableActions();

        public void errorOnInterval();

        public String getStartScannerErrorMessage();

        public String getStopScannerErrorMessage();

        public String getScanNowErrorMessage();

        public String getUpgradeErrorMessage();
    }
}

