/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.container.status.card;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.workbench.common.screens.server.management.client.events.ServerInstanceSelected;
import org.kie.workbench.common.screens.server.management.client.util.IOCUtil;
import org.kie.workbench.common.screens.server.management.client.widget.card.CardPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.body.BodyPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.footer.FooterPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.title.LinkTitlePresenter;
import org.uberfire.mvp.Command;

@Dependent
public class ContainerCardPresenter {
    private final View view;
    private final IOCUtil iocUtil;
    private final Event<ServerInstanceSelected> remoteServerSelectedEvent;
    private LinkTitlePresenter linkTitlePresenter;
    private BodyPresenter bodyPresenter;
    private FooterPresenter footerPresenter;

    @Inject
    public ContainerCardPresenter(View view, IOCUtil iocUtil, Event<ServerInstanceSelected> remoteServerSelectedEvent) {
        this.view = view;
        this.iocUtil = iocUtil;
        this.remoteServerSelectedEvent = remoteServerSelectedEvent;
    }

    public View getView() {
        return this.view;
    }

    public void setup(ServerInstanceKey serverInstanceKey, Container container) {
        this.linkTitlePresenter = this.iocUtil.newInstance(this, LinkTitlePresenter.class);
        this.bodyPresenter = this.iocUtil.newInstance(this, BodyPresenter.class);
        this.footerPresenter = this.iocUtil.newInstance(this, FooterPresenter.class);
        this.updateContent(serverInstanceKey, container);
        CardPresenter card = this.iocUtil.newInstance(this, CardPresenter.class);
        card.addTitle(this.linkTitlePresenter);
        card.addBody(this.bodyPresenter);
        card.addFooter(this.footerPresenter);
        this.view.setCard(card.getView());
    }

    public void delete() {
        this.view.delete();
    }

    public void updateContent(final ServerInstanceKey serverInstanceKey, Container container) {
        this.linkTitlePresenter.setup(serverInstanceKey.getServerName(), new Command(){

            public void execute() {
                ContainerCardPresenter.this.remoteServerSelectedEvent.fire((Object)new ServerInstanceSelected(serverInstanceKey));
            }
        });
        this.bodyPresenter.setup(container.getMessages());
        this.footerPresenter.setup(container.getUrl(), container.getResolvedReleasedId().getVersion());
    }

    @PreDestroy
    public void destroy() {
        this.iocUtil.cleanup(this);
    }

    public static interface View
    extends IsWidget {
        public void setCard(CardPresenter.View var1);

        public void delete();
    }
}

