/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.navigation.template.copy;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.html.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.server.management.client.navigation.template.copy.CopyPopupPresenter;
import org.uberfire.ext.widgets.common.client.common.StyleHelper;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

@Dependent
@Templated
public class CopyPopupView
extends Composite
implements CopyPopupPresenter.View {
    private CopyPopupPresenter presenter;
    private final BaseModal modal;
    private final TranslationService translationService;
    @DataField(value="template-name-group")
    Element templateNameGroup = DOM.createDiv();
    @Inject
    @DataField(value="template-name-label")
    FormLabel templateNameLabel;
    @Inject
    @DataField(value="template-name")
    TextBox templateName;
    @Inject
    @DataField(value="template-name-help")
    Span templateNameHelp;

    @Inject
    public CopyPopupView(TranslationService translationService) {
        this.translationService = translationService;
        this.modal = new BaseModal();
    }

    public void init(final CopyPopupPresenter presenter) {
        this.presenter = presenter;
        this.templateName.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (!CopyPopupView.this.templateName.getText().trim().isEmpty()) {
                    StyleHelper.addUniqueEnumStyleName((Element)CopyPopupView.this.templateNameGroup, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
                    CopyPopupView.this.templateNameHelp.setVisible(false);
                }
            }
        });
        this.modal.setTitle(this.getCopyServerTemplatePopupTitle());
        this.modal.setBody((Widget)this);
        this.templateNameLabel.setText(this.getTemplateNameLabelText());
        this.modal.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                presenter.save();
            }
        }, new Command(){

            public void execute() {
                CopyPopupView.this.hide();
            }
        }));
    }

    @Override
    public void clear() {
        this.templateName.setText("");
        StyleHelper.addUniqueEnumStyleName((Element)this.templateNameGroup, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
        this.templateNameHelp.setVisible(false);
    }

    @Override
    public String getNewTemplateName() {
        return this.templateName.getText();
    }

    @Override
    public void errorOnTemplateNameFromGroup() {
        StyleHelper.addUniqueEnumStyleName((Element)this.templateNameGroup, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
        this.templateNameHelp.setText(this.getTemplateNameEmptyMessage());
        this.templateNameHelp.setVisible(true);
    }

    @Override
    public void display() {
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void errorOnTemplateNameFromGroup(String message) {
        StyleHelper.addUniqueEnumStyleName((Element)this.templateNameGroup, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
        this.templateNameHelp.setText(message);
        this.templateNameHelp.setVisible(true);
    }

    private String getTemplateNameLabelText() {
        return this.translationService.format("CopyPopupView.TemplateNameLabelText", new Object[0]);
    }

    private String getCopyServerTemplatePopupTitle() {
        return this.translationService.format("CopyPopupView.CopyServerTemplatePopupTitle", new Object[0]);
    }

    private String getTemplateNameEmptyMessage() {
        return this.translationService.format("CopyPopupView.TemplateNameEmptyMessage", new Object[0]);
    }
}

