/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.remote;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.workbench.common.screens.server.management.client.events.ServerInstanceSelected;
import org.kie.workbench.common.screens.server.management.client.remote.RemoteStatusPresenter;
import org.kie.workbench.common.screens.server.management.client.remote.empty.RemoteEmptyPresenter;
import org.kie.workbench.common.screens.server.management.client.util.Convert;
import org.kie.workbench.common.screens.server.management.service.RuntimeManagementService;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.slf4j.Logger;
import org.uberfire.client.mvp.UberView;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class RemotePresenter {
    private final Logger logger;
    private final View view;
    private final RemoteStatusPresenter remoteStatusPresenter;
    private final RemoteEmptyPresenter remoteEmptyPresenter;
    private final Caller<RuntimeManagementService> runtimeManagementService;
    private final Caller<SpecManagementService> specManagementServiceCaller;
    private final Event<NotificationEvent> notification;
    private ServerInstanceKey serverInstanceKey;

    @Inject
    public RemotePresenter(Logger logger, View view, RemoteStatusPresenter remoteStatusPresenter, RemoteEmptyPresenter remoteEmptyPresenter, Caller<RuntimeManagementService> runtimeManagementService, Caller<SpecManagementService> specManagementServiceCaller, Event<NotificationEvent> notification) {
        this.logger = logger;
        this.view = view;
        this.remoteStatusPresenter = remoteStatusPresenter;
        this.remoteEmptyPresenter = remoteEmptyPresenter;
        this.runtimeManagementService = runtimeManagementService;
        this.specManagementServiceCaller = specManagementServiceCaller;
        this.notification = notification;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void onSelect(@Observes ServerInstanceSelected serverInstanceSelected) {
        if (serverInstanceSelected != null && serverInstanceSelected.getServerInstanceKey() != null) {
            this.serverInstanceKey = serverInstanceSelected.getServerInstanceKey();
            this.refresh();
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void onInstanceUpdate(@Observes ServerInstanceUpdated serverInstanceUpdated) {
        if (serverInstanceUpdated != null && serverInstanceUpdated.getServerInstance() != null) {
            ServerInstanceKey updatedServerInstanceKey = Convert.toKey(serverInstanceUpdated.getServerInstance());
            if (this.serverInstanceKey.getServerInstanceId().equals(updatedServerInstanceKey.getServerInstanceId())) {
                this.serverInstanceKey = updatedServerInstanceKey;
                this.loadContent(serverInstanceUpdated.getServerInstance().getContainers());
            }
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void remove() {
        ((SpecManagementService)this.specManagementServiceCaller.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void aVoid) {
                RemotePresenter.this.notification.fire((Object)new NotificationEvent(RemotePresenter.this.view.getRemoteInstanceRemoveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                RemotePresenter.this.notification.fire((Object)new NotificationEvent(RemotePresenter.this.view.getRemoteInstanceRemoveErrorMessage(), NotificationEvent.NotificationType.ERROR));
                return false;
            }
        })).deleteServerInstance(this.serverInstanceKey);
    }

    public void refresh() {
        this.load(this.serverInstanceKey);
    }

    public void load(ServerInstanceKey serverInstanceKey) {
        ((RuntimeManagementService)this.runtimeManagementService.call((RemoteCallback)new RemoteCallback<Collection<Container>>(){

            public void callback(Collection<Container> containers) {
                RemotePresenter.this.loadContent(containers);
            }
        })).getContainersByServerInstance(serverInstanceKey.getServerTemplateId(), serverInstanceKey.getServerInstanceId());
    }

    private void loadContent(Collection<Container> containers) {
        this.view.clear();
        this.view.setServerName(this.serverInstanceKey.getServerName());
        this.view.setServerURL(this.serverInstanceKey.getUrl());
        if (containers.isEmpty()) {
            this.view.setEmptyView(this.remoteEmptyPresenter.getView());
        } else {
            this.remoteStatusPresenter.setup(containers);
            this.view.setStatusPresenter(this.remoteStatusPresenter.getView());
        }
    }

    public static interface View
    extends UberView<RemotePresenter> {
        public void clear();

        public void setServerName(String var1);

        public void setServerURL(String var1);

        public void setEmptyView(RemoteEmptyPresenter.View var1);

        public void setStatusPresenter(RemoteStatusPresenter.View var1);

        public String getRemoteInstanceRemoveSuccessMessage();

        public String getRemoteInstanceRemoveErrorMessage();
    }
}

