/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.util;

import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.server.management.model.MergeMode;

public enum ClientMergeMode {
    MERGE_COLLECTIONS("ClientMergeMode.MergeCollections", MergeMode.MERGE_COLLECTIONS),
    KEEP_ALL("ClientMergeMode.KeepAll", MergeMode.KEEP_ALL),
    OVERRIDE_ALL("ClientMergeMode.OverrideAll", MergeMode.OVERRIDE_ALL),
    OVERRIDE_EMPTY("ClientMergeMode.OverrideEmpty", MergeMode.OVERRIDE_EMPTY);

    private final String valueTranslationKey;
    private final MergeMode mergeMode;

    private ClientMergeMode(String valueTranslationKey, MergeMode mergeMode) {
        this.valueTranslationKey = valueTranslationKey;
        this.mergeMode = mergeMode;
    }

    public String getValue(TranslationService translationService) {
        return translationService.format(this.valueTranslationKey, new Object[0]);
    }

    public MergeMode getMergeMode() {
        return this.mergeMode;
    }

    public static ClientMergeMode convert(MergeMode mergeMode) {
        switch (mergeMode) {
            case KEEP_ALL: {
                return KEEP_ALL;
            }
            case OVERRIDE_ALL: {
                return OVERRIDE_ALL;
            }
            case OVERRIDE_EMPTY: {
                return OVERRIDE_EMPTY;
            }
            case MERGE_COLLECTIONS: {
                return MERGE_COLLECTIONS;
            }
        }
        throw new RuntimeException("Invalid parameter");
    }

    public static ClientMergeMode convert(String mergeMode, TranslationService translationService) {
        for (ClientMergeMode clientMergeMode : ClientMergeMode.values()) {
            if (!mergeMode.equals(clientMergeMode.getValue(translationService))) continue;
            return clientMergeMode;
        }
        return KEEP_ALL;
    }

    public static List<String> listMergeModeValues(TranslationService translationService) {
        ArrayList<String> mergeModeValues = new ArrayList<String>();
        for (ClientMergeMode clientMergeMode : ClientMergeMode.values()) {
            mergeModeValues.add(clientMergeMode.getValue(translationService));
        }
        return mergeModeValues;
    }
}

