/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.wizard.container;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.html.Div;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.server.management.client.util.ContentChangeHandler;
import org.kie.workbench.common.screens.server.management.client.widget.artifact.ArtifactListWidgetPresenter;
import org.kie.workbench.common.screens.server.management.client.wizard.container.NewContainerFormPresenter;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.common.client.common.StyleHelper;

@Dependent
@Templated
public class NewContainerFormView
extends Composite
implements NewContainerFormPresenter.View {
    private TranslationService translationService;
    @DataField(value="new-container-name-form")
    Element containerNameGroup = DOM.createDiv();
    @Inject
    @DataField(value="new-container-name")
    TextBox containerName;
    @DataField(value="new-container-name-help")
    Element containerNameHelp = DOM.createSpan();
    @DataField(value="new-group-id-form")
    Element groupIdGroup = DOM.createDiv();
    @Inject
    @DataField(value="new-group-id")
    TextBox groupId;
    @DataField(value="new-artifact-id-form")
    Element artifactIdGroup = DOM.createDiv();
    @Inject
    @DataField(value="new-artifact-id")
    TextBox artifactId;
    @DataField(value="new-version-form")
    Element versionGroup = DOM.createDiv();
    @Inject
    @DataField(value="new-version")
    TextBox version;
    @Inject
    @DataField(value="content-area")
    Div content;
    private final ArrayList<ContentChangeHandler> changeHandlers = new ArrayList();

    @Inject
    public NewContainerFormView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(final NewContainerFormPresenter presenter) {
        this.containerName.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (presenter.isContainerNameValid()) {
                    NewContainerFormView.this.noErrorOnContainerName();
                } else {
                    NewContainerFormView.this.errorOnContainerName();
                }
                NewContainerFormView.this.fireChangeHandlers();
            }
        });
        this.groupId.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (presenter.isGroupIdValid()) {
                    NewContainerFormView.this.noErrorOnGroupId();
                } else {
                    NewContainerFormView.this.errorOnGroupId();
                }
                NewContainerFormView.this.fireChangeHandlers();
            }
        });
        this.artifactId.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (presenter.isArtifactIdValid()) {
                    NewContainerFormView.this.noErrorOnArtifactId();
                } else {
                    NewContainerFormView.this.errorOnArtifactId();
                }
                NewContainerFormView.this.fireChangeHandlers();
            }
        });
        this.version.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (presenter.isVersionValid()) {
                    NewContainerFormView.this.noErrorOnVersion();
                } else {
                    NewContainerFormView.this.errorOnVersion();
                }
                NewContainerFormView.this.fireChangeHandlers();
            }
        });
    }

    private void fireChangeHandlers() {
        for (ContentChangeHandler changeHandler : this.changeHandlers) {
            changeHandler.onContentChange();
        }
    }

    @Override
    public String getTitle() {
        return this.getTitleText();
    }

    @Override
    public void setArtifactListWidgetView(ArtifactListWidgetPresenter.View view) {
        this.content.add((IsWidget)view);
    }

    @Override
    public void clear() {
        this.containerName.setText("");
        this.groupId.setText("");
        this.artifactId.setText("");
        this.version.setText("");
        this.noErrors();
    }

    @Override
    public void noErrors() {
        this.noErrorOnContainerName();
        this.noErrorOnGroupId();
        this.noErrorOnArtifactId();
        this.noErrorOnVersion();
    }

    @Override
    public void noErrorOnContainerName() {
        this.containerNameHelp.getStyle().setVisibility(Style.Visibility.HIDDEN);
        StyleHelper.addUniqueEnumStyleName((Element)this.containerNameGroup, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
    }

    @Override
    public void noErrorOnGroupId() {
        StyleHelper.addUniqueEnumStyleName((Element)this.groupIdGroup, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
    }

    @Override
    public void noErrorOnArtifactId() {
        StyleHelper.addUniqueEnumStyleName((Element)this.artifactIdGroup, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
    }

    @Override
    public void noErrorOnVersion() {
        StyleHelper.addUniqueEnumStyleName((Element)this.versionGroup, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
    }

    @Override
    public void addContentChangeHandler(ContentChangeHandler contentChangeHandler) {
        this.changeHandlers.add((ContentChangeHandler)PortablePreconditions.checkNotNull((String)"contentChangeHandler", (Object)contentChangeHandler));
    }

    @Override
    public void setGroupId(String value) {
        this.groupId.setText(value);
    }

    @Override
    public void setArtifactId(String value) {
        this.artifactId.setText(value);
    }

    @Override
    public void setVersion(String value) {
        this.version.setText(value);
    }

    @Override
    public String getContainerName() {
        return this.containerName.getText();
    }

    @Override
    public String getGroupId() {
        return this.groupId.getText();
    }

    @Override
    public String getArtifactId() {
        return this.artifactId.getText();
    }

    @Override
    public String getVersion() {
        return this.version.getText();
    }

    @Override
    public void errorOnContainerName() {
        StyleHelper.addUniqueEnumStyleName((Element)this.containerNameGroup, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
    }

    @Override
    public void errorOnContainerName(String message) {
        this.errorOnContainerName();
        this.containerNameHelp.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.containerNameHelp.setInnerText(message);
    }

    @Override
    public void errorOnGroupId() {
        StyleHelper.addUniqueEnumStyleName((Element)this.groupIdGroup, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
    }

    @Override
    public void errorOnArtifactId() {
        StyleHelper.addUniqueEnumStyleName((Element)this.artifactIdGroup, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
    }

    @Override
    public void errorOnVersion() {
        StyleHelper.addUniqueEnumStyleName((Element)this.versionGroup, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
    }

    @Override
    public String getInvalidErrorMessage() {
        return this.translationService.format("NewContainerFormView.InvalidErrorMessage", new Object[0]);
    }

    @Override
    public String getNewContainerWizardTitle() {
        return this.translationService.format("NewContainerFormView.NewContainerWizardTitle", new Object[0]);
    }

    @Override
    public String getNewContainerWizardSaveSuccess() {
        return this.translationService.format("NewContainerFormView.NewContainerWizardSaveSuccess", new Object[0]);
    }

    @Override
    public String getNewContainerWizardSaveError() {
        return this.translationService.format("NewContainerFormView.NewContainerWizardSaveError", new Object[0]);
    }

    private String getTitleText() {
        return this.translationService.format("NewContainerFormView.TitleText", new Object[0]);
    }
}

