/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.container;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.html.Div;
import org.gwtbootstrap3.client.ui.html.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.server.management.client.container.ContainerPresenter;
import org.kie.workbench.common.screens.server.management.client.container.config.process.ContainerProcessConfigPresenter;
import org.kie.workbench.common.screens.server.management.client.container.config.rules.ContainerRulesConfigPresenter;
import org.kie.workbench.common.screens.server.management.client.util.State;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ContainerView
extends Composite
implements ContainerPresenter.View {
    private ContainerPresenter presenter;
    private TranslationService translationService;
    @DataField(value="container-name")
    Element containerName = DOM.createSpan();
    @Inject
    @DataField(value="container-config-start")
    Button containerStart;
    @Inject
    @DataField(value="container-config-stop")
    Button containerStop;
    @Inject
    @DataField(value="remove-container")
    Button removeContainer;
    @Inject
    @DataField(value="group-id")
    Span groupId;
    @Inject
    @DataField(value="artifact-id")
    Span artifactId;
    @Inject
    @DataField(value="refresh-container")
    Button refreshContainer;
    @DataField(value="status-tab")
    Element statusTab = DOM.createElement((String)"li");
    @DataField(value="status-tab-link")
    Element statusTabLink = DOM.createAnchor();
    @DataField(value="rules-tab")
    Element rulesTab = DOM.createElement((String)"li");
    @DataField(value="rules-tab-link")
    Element rulesTabLink = DOM.createAnchor();
    @DataField(value="process-tab")
    Element processTab = DOM.createElement((String)"li");
    @DataField(value="process-tab-link")
    Element processTabLink = DOM.createAnchor();
    @DataField(value="status-pane")
    Element statusPane = DOM.createDiv();
    @Inject
    @DataField(value="status-content")
    Div statusContent;
    @DataField(value="rules-pane")
    Element rulesPane = DOM.createDiv();
    @Inject
    @DataField(value="rules-content")
    Div rulesContent;
    @DataField(value="process-pane")
    Element processPane = DOM.createDiv();
    @Inject
    @DataField(value="process-content")
    Div processContent;

    @Inject
    public ContainerView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(ContainerPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void clear() {
        this.containerName.setInnerText("");
        this.artifactId.setText("");
        this.groupId.setText("");
    }

    @Override
    public void disableRemoveButton() {
        this.removeContainer.setEnabled(false);
    }

    @Override
    public void enableRemoveButton() {
        this.removeContainer.setEnabled(true);
    }

    @Override
    public void setContainerName(String containerName) {
        this.containerName.setInnerText(containerName);
    }

    @Override
    public void setGroupIp(String groupIp) {
        this.groupId.setText(groupIp);
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.artifactId.setText(artifactId);
    }

    @Override
    public void setStatus(IsWidget view) {
        this.statusContent.clear();
        this.statusContent.add(view);
    }

    @Override
    public void setProcessConfig(ContainerProcessConfigPresenter.View view) {
        this.processContent.clear();
        this.processContent.add((IsWidget)view);
    }

    @Override
    public void setRulesConfig(ContainerRulesConfigPresenter.View view) {
        this.rulesContent.clear();
        this.rulesContent.add((IsWidget)view);
    }

    @Override
    public void setContainerStartState(State state) {
        this.containerStop.setEnabled(state.equals((Object)State.ENABLED));
        this.containerStop.setActive(!state.equals((Object)State.ENABLED));
    }

    @Override
    public void confirmRemove(Command command) {
        YesNoCancelPopup result = YesNoCancelPopup.newYesNoCancelPopup((String)this.getConfirmRemovePopupTitle(), (String)this.getConfirmRemovePopupMessage(), (Command)command, (Command)new Command(){

            public void execute() {
            }
        }, null);
        result.clearScrollHeight();
        result.show();
    }

    @Override
    public void setContainerStopState(State state) {
        this.containerStart.setEnabled(state.equals((Object)State.ENABLED));
        this.containerStart.setActive(!state.equals((Object)State.ENABLED));
    }

    @EventHandler(value={"refresh-container"})
    public void refresh(ClickEvent event) {
        this.presenter.refresh();
    }

    @EventHandler(value={"remove-container"})
    public void removeContainer(ClickEvent event) {
        this.presenter.removeContainer();
    }

    @EventHandler(value={"container-config-start"})
    public void startContainer(ClickEvent event) {
        this.presenter.startContainer();
    }

    @EventHandler(value={"container-config-stop"})
    public void stopContainer(ClickEvent event) {
        this.presenter.stopContainer();
    }

    @Override
    public String getRemoveContainerSuccessMessage() {
        return this.translationService.format("ContainerView.RemoveContainerSuccessMessage", new Object[0]);
    }

    @Override
    public String getRemoveContainerErrorMessage() {
        return this.translationService.format("ContainerView.RemoveContainerErrorMessage", new Object[0]);
    }

    @Override
    public String getStopContainerErrorMessage() {
        return this.translationService.format("ContainerView.StopContainerErrorMessage", new Object[0]);
    }

    @Override
    public String getStartContainerErrorMessage() {
        return this.translationService.format("ContainerView.StartContainerErrorMessage", new Object[0]);
    }

    private String getConfirmRemovePopupMessage() {
        return this.translationService.format("ContainerView.ConfirmRemovePopupMessage", new Object[0]);
    }

    private String getConfirmRemovePopupTitle() {
        return this.translationService.format("ContainerView.ConfirmRemovePopupTitle", new Object[0]);
    }
}

