/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.navigation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.workbench.common.screens.server.management.client.events.AddNewServerTemplate;
import org.kie.workbench.common.screens.server.management.client.events.ServerTemplateListRefresh;
import org.kie.workbench.common.screens.server.management.client.events.ServerTemplateSelected;
import org.slf4j.Logger;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
public class ServerNavigationPresenter {
    private final Logger logger;
    private final View view;
    private final Event<AddNewServerTemplate> addNewServerTemplateEvent;
    private final Event<ServerTemplateListRefresh> serverTemplateListRefreshEvent;
    private final Event<ServerTemplateSelected> serverTemplateSelectedEvent;
    private Set<String> serverTemplates = new HashSet<String>();

    @Inject
    public ServerNavigationPresenter(Logger logger, View view, Event<AddNewServerTemplate> addNewServerTemplateEvent, Event<ServerTemplateListRefresh> serverTemplateListRefreshEvent, Event<ServerTemplateSelected> serverTemplateSelectedEvent) {
        this.logger = logger;
        this.view = view;
        this.addNewServerTemplateEvent = addNewServerTemplateEvent;
        this.serverTemplateListRefreshEvent = serverTemplateListRefreshEvent;
        this.serverTemplateSelectedEvent = serverTemplateSelectedEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void setup(ServerTemplateKey firstTemplate, Collection<ServerTemplateKey> serverTemplateKeys) {
        this.view.clean();
        this.serverTemplates.clear();
        this.addTemplate((ServerTemplateKey)PortablePreconditions.checkNotNull((String)"serverTemplate2BeSelected", (Object)firstTemplate));
        for (ServerTemplateKey serverTemplateKey : serverTemplateKeys) {
            if (serverTemplateKey.equals((Object)firstTemplate)) continue;
            this.addTemplate(serverTemplateKey);
        }
    }

    private void addTemplate(ServerTemplateKey serverTemplateKey) {
        PortablePreconditions.checkNotNull((String)"serverTemplateKey", (Object)serverTemplateKey);
        this.serverTemplates.add(serverTemplateKey.getId());
        this.view.addTemplate(serverTemplateKey.getId(), serverTemplateKey.getName());
    }

    public void onSelect(@Observes ServerTemplateSelected serverTemplateSelected) {
        if (serverTemplateSelected != null && serverTemplateSelected.getServerTemplateKey() != null && serverTemplateSelected.getServerTemplateKey().getId() != null) {
            this.view.select(serverTemplateSelected.getServerTemplateKey().getId());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void onServerTemplateUpdated(@Observes ServerTemplateUpdated serverTemplateUpdated) {
        if (serverTemplateUpdated != null && serverTemplateUpdated.getServerTemplate() != null) {
            ServerTemplate serverTemplate = serverTemplateUpdated.getServerTemplate();
            if (!this.serverTemplates.contains(serverTemplate.getId())) {
                this.addTemplate((ServerTemplateKey)serverTemplate);
            }
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void select(String id) {
        this.serverTemplateSelectedEvent.fire((Object)new ServerTemplateSelected(new ServerTemplateKey(id, "")));
    }

    public void clear() {
        this.view.clean();
    }

    public void refresh() {
        this.serverTemplateListRefreshEvent.fire((Object)new ServerTemplateListRefresh());
    }

    public void newTemplate() {
        this.addNewServerTemplateEvent.fire((Object)new AddNewServerTemplate());
    }

    public static interface View
    extends UberView<ServerNavigationPresenter> {
        public void addTemplate(String var1, String var2);

        public void select(String var1);

        public void clean();
    }
}

