/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.navigation.template;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.workbench.common.screens.server.management.client.events.AddNewContainer;
import org.kie.workbench.common.screens.server.management.client.events.ContainerSpecSelected;
import org.kie.workbench.common.screens.server.management.client.events.ServerInstanceSelected;
import org.kie.workbench.common.screens.server.management.client.events.ServerTemplateListRefresh;
import org.kie.workbench.common.screens.server.management.client.navigation.template.copy.CopyPopupPresenter;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.slf4j.Logger;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class ServerTemplatePresenter {
    private final Logger logger;
    private final View view;
    private final CopyPopupPresenter copyPresenter;
    private final Caller<SpecManagementService> specManagementService;
    private final Event<NotificationEvent> notification;
    private final Event<AddNewContainer> addNewContainerEvent;
    private final Event<ContainerSpecSelected> containerSpecSelectedEvent;
    private final Event<ServerInstanceSelected> serverInstanceSelectedEvent;
    private final Event<ServerTemplateListRefresh> serverTemplateListRefreshEvent;
    private ServerTemplate serverTemplate;
    private Set<String> serverInstances = new HashSet<String>();

    @Inject
    public ServerTemplatePresenter(Logger logger, View view, CopyPopupPresenter copyPresenter, Caller<SpecManagementService> specManagementService, Event<NotificationEvent> notification, Event<AddNewContainer> addNewContainerEvent, Event<ContainerSpecSelected> containerSpecSelectedEvent, Event<ServerInstanceSelected> serverInstanceSelectedEvent, Event<ServerTemplateListRefresh> serverTemplateListRefreshEvent) {
        this.logger = logger;
        this.view = view;
        this.copyPresenter = copyPresenter;
        this.specManagementService = specManagementService;
        this.notification = notification;
        this.addNewContainerEvent = addNewContainerEvent;
        this.containerSpecSelectedEvent = containerSpecSelectedEvent;
        this.serverInstanceSelectedEvent = serverInstanceSelectedEvent;
        this.serverTemplateListRefreshEvent = serverTemplateListRefreshEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public ServerTemplate getCurrentServerTemplate() {
        return this.serverTemplate;
    }

    public void setup(ServerTemplate serverTemplate, ContainerSpec firstContainerSpec) {
        this.view.clear();
        this.serverTemplate = serverTemplate;
        this.view.setTemplate(serverTemplate.getId(), serverTemplate.getName());
        this.view.setProcessCapability(serverTemplate.getCapabilities().contains(Capability.PROCESS.toString()));
        this.view.setRulesCapability(serverTemplate.getCapabilities().contains(Capability.RULE.toString()));
        this.view.setPlanningCapability(serverTemplate.getCapabilities().contains(Capability.PLANNING.toString()));
        if (firstContainerSpec != null) {
            this.addContainer(firstContainerSpec);
            for (ContainerSpec containerSpec : serverTemplate.getContainersSpec()) {
                if (containerSpec.getId().equals(firstContainerSpec.getId())) continue;
                this.addContainer(containerSpec);
            }
            this.containerSpecSelectedEvent.fire((Object)new ContainerSpecSelected((ContainerSpecKey)firstContainerSpec));
        }
        for (ServerInstanceKey serverInstanceKey : serverTemplate.getServerInstanceKeys()) {
            this.addServerInstance(serverInstanceKey);
        }
    }

    private void addContainer(final ContainerSpec containerSpec) {
        this.view.addContainer(containerSpec.getServerTemplateKey().getId(), containerSpec.getId(), containerSpec.getContainerName(), new Command(){

            public void execute() {
                ServerTemplatePresenter.this.containerSpecSelectedEvent.fire((Object)new ContainerSpecSelected((ContainerSpecKey)containerSpec));
            }
        });
    }

    private void addServerInstance(final ServerInstanceKey serverInstanceKey) {
        this.serverInstances.add(serverInstanceKey.getServerInstanceId());
        this.view.addServerInstance(serverInstanceKey.getServerTemplateId(), serverInstanceKey.getServerInstanceId(), serverInstanceKey.getServerName(), new Command(){

            public void execute() {
                ServerTemplatePresenter.this.serverInstanceSelectedEvent.fire((Object)new ServerInstanceSelected(serverInstanceKey));
            }
        });
    }

    public void onContainerSelect(@Observes ContainerSpecSelected containerSpecSelected) {
        if (containerSpecSelected != null && containerSpecSelected.getContainerSpecKey() != null && containerSpecSelected.getContainerSpecKey().getServerTemplateKey() != null && containerSpecSelected.getContainerSpecKey().getServerTemplateKey().getId() != null && containerSpecSelected.getContainerSpecKey().getId() != null) {
            this.view.selectContainer(containerSpecSelected.getContainerSpecKey().getServerTemplateKey().getId(), containerSpecSelected.getContainerSpecKey().getId());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void onServerInstanceSelect(@Observes ServerInstanceSelected serverInstanceSelected) {
        if (serverInstanceSelected != null && serverInstanceSelected.getServerInstanceKey() != null && serverInstanceSelected.getServerInstanceKey().getServerTemplateId() != null && serverInstanceSelected.getServerInstanceKey().getServerInstanceId() != null) {
            this.view.selectServerInstance(serverInstanceSelected.getServerInstanceKey().getServerTemplateId(), serverInstanceSelected.getServerInstanceKey().getServerInstanceId());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void onServerInstanceUpdated(@Observes ServerInstanceUpdated serverInstanceUpdated) {
        if (serverInstanceUpdated != null && serverInstanceUpdated.getServerInstance() != null) {
            ServerInstance updatedServerInstance = serverInstanceUpdated.getServerInstance();
            if (updatedServerInstance.getServerTemplateId().equals(this.serverTemplate.getId()) && !this.serverInstances.contains(updatedServerInstance.getServerInstanceId())) {
                this.addServerInstance((ServerInstanceKey)updatedServerInstance);
            }
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void onServerInstanceDeleted(@Observes ServerInstanceDeleted serverInstanceDeleted) {
        if (serverInstanceDeleted != null && serverInstanceDeleted.getServerInstanceId() != null) {
            this.serverInstances.remove(serverInstanceDeleted.getServerInstanceId());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void addNewContainer() {
        this.addNewContainerEvent.fire((Object)new AddNewContainer(this.serverTemplate));
    }

    public void copyTemplate() {
        this.copyPresenter.copy(new ParameterizedCommand<String>(){

            public void execute(final String value) {
                ((SpecManagementService)ServerTemplatePresenter.this.specManagementService.call((RemoteCallback)new RemoteCallback<Void>(){

                    public void callback(Void aVoid) {
                        ServerTemplatePresenter.this.copyPresenter.hide();
                        ServerTemplatePresenter.this.serverTemplateListRefreshEvent.fire((Object)new ServerTemplateListRefresh(value));
                    }
                }, (ErrorCallback)new ErrorCallback<Object>(){

                    public boolean error(Object o, Throwable throwable) {
                        ServerTemplatePresenter.this.copyPresenter.errorDuringProcessing(ServerTemplatePresenter.this.view.getCopyTemplateErrorMessage());
                        return false;
                    }
                })).copyServerTemplate(ServerTemplatePresenter.this.serverTemplate.getId(), value, value);
            }
        });
    }

    public void removeTemplate() {
        this.view.confirmRemove(new Command(){

            public void execute() {
                ((SpecManagementService)ServerTemplatePresenter.this.specManagementService.call((RemoteCallback)new RemoteCallback<Void>(){

                    public void callback(Void aVoid) {
                        ServerTemplatePresenter.this.serverTemplateListRefreshEvent.fire((Object)new ServerTemplateListRefresh());
                    }
                }, (ErrorCallback)new ErrorCallback<Object>(){

                    public boolean error(Object o, Throwable throwable) {
                        ServerTemplatePresenter.this.notification.fire((Object)new NotificationEvent(ServerTemplatePresenter.this.view.getRemoveTemplateErrorMessage(), NotificationEvent.NotificationType.ERROR));
                        ServerTemplatePresenter.this.serverTemplateListRefreshEvent.fire((Object)new ServerTemplateListRefresh());
                        return false;
                    }
                })).deleteServerTemplate(ServerTemplatePresenter.this.serverTemplate.getId());
            }
        });
    }

    public static interface View
    extends UberView<ServerTemplatePresenter> {
        public void clear();

        public void setTemplate(String var1, String var2);

        public void selectContainer(String var1, String var2);

        public void selectServerInstance(String var1, String var2);

        public void addContainer(String var1, String var2, String var3, Command var4);

        public void addServerInstance(String var1, String var2, String var3, Command var4);

        public void setRulesCapability(boolean var1);

        public void setProcessCapability(boolean var1);

        public void setPlanningCapability(boolean var1);

        public void confirmRemove(Command var1);

        public String getCopyTemplateErrorMessage();

        public String getRemoveTemplateErrorMessage();
    }
}

