/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.navigation.template;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.LinkedGroup;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.server.management.client.navigation.template.ServerTemplatePresenter;
import org.kie.workbench.common.screens.server.management.client.widget.CustomGroupItem;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ServerTemplateView
extends Composite
implements ServerTemplatePresenter.View {
    private ServerTemplatePresenter presenter;
    private TranslationService translationService;
    @DataField(value="current-server-template-name")
    Element serverTemplate = DOM.createElement((String)"strong");
    @Inject
    @DataField(value="rule-capability-checkbox")
    CheckBox ruleEnabled;
    @Inject
    @DataField(value="process-capability-checkbox")
    CheckBox processEnabled;
    @Inject
    @DataField(value="planning-capability-checkbox")
    CheckBox planningEnabled;
    @Inject
    @DataField(value="add-new-container")
    Anchor addNewContainer;
    @Inject
    @DataField(value="copy-current-server-template")
    Anchor copyTemplate;
    @Inject
    @DataField(value="remove-current-server-template")
    Anchor removeTemplate;
    @Inject
    @DataField(value="container-list-group")
    LinkedGroup containersListGroup;
    @Inject
    @DataField(value="remote-server-list-group")
    LinkedGroup remoteServersListGroup;
    private Map<String, CustomGroupItem> serverInstanceItems = new HashMap<String, CustomGroupItem>();
    private Map<String, CustomGroupItem> containerItems = new HashMap<String, CustomGroupItem>();
    private CustomGroupItem selected = null;
    private String templateId;

    @Inject
    public ServerTemplateView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(ServerTemplatePresenter presenter) {
        this.presenter = presenter;
        this.ruleEnabled.setText(this.getRuleCheckBoxText());
        this.ruleEnabled.setEnabled(false);
        this.processEnabled.setText(this.getProcessCheckBoxText());
        this.processEnabled.setEnabled(false);
        this.planningEnabled.setText(this.getPlanningCheckBoxText());
        this.planningEnabled.setEnabled(false);
    }

    @Override
    public void clear() {
        this.remoteServersListGroup.clear();
        this.containersListGroup.clear();
        this.serverInstanceItems.clear();
        this.containerItems.clear();
        this.selected = null;
        this.templateId = null;
        this.serverTemplate.setInnerText("");
        this.processEnabled.setValue(Boolean.valueOf(false));
        this.ruleEnabled.setValue(Boolean.valueOf(false));
        this.planningEnabled.setValue(Boolean.valueOf(false));
    }

    @Override
    public void setTemplate(String templateId, String templateName) {
        this.templateId = templateId;
        this.serverTemplate.setInnerText(templateName);
        this.serverInstanceItems.clear();
        this.containerItems.clear();
        this.containersListGroup.clear();
        this.remoteServersListGroup.clear();
    }

    @Override
    public void selectContainer(String serverTemplateId, String id) {
        this.select(serverTemplateId, id, this.containerItems);
    }

    @Override
    public void selectServerInstance(String serverTemplateId, String id) {
        this.select(serverTemplateId, id, this.serverInstanceItems);
    }

    private void select(String serverTemplateId, String id, Map<String, CustomGroupItem> map) {
        PortablePreconditions.checkNotEmpty((String)"serverTemplateId", (String)serverTemplateId);
        PortablePreconditions.checkNotEmpty((String)"id", (String)id);
        if (this.selected != null) {
            this.selected.setActive(false);
            this.selected.removeStyleName("active");
        }
        if (!serverTemplateId.equals(this.templateId)) {
            return;
        }
        this.selected = map.get(id);
        this.selected.setActive(true);
    }

    @Override
    public void addContainer(String serverTemplateId, String containerSpecId, String containerName, Command onSelect) {
        if (!serverTemplateId.equals(this.templateId)) {
            return;
        }
        CustomGroupItem groupItem = new CustomGroupItem(containerName, IconType.FOLDER_O, onSelect);
        this.containerItems.put(containerSpecId, groupItem);
        this.containersListGroup.add((Widget)groupItem);
    }

    @Override
    public void addServerInstance(String serverTemplateId, String serverInstanceId, String serverName, Command onSelect) {
        if (!serverTemplateId.equals(this.templateId)) {
            return;
        }
        CustomGroupItem groupItem = new CustomGroupItem(serverName, IconType.SERVER, onSelect);
        this.serverInstanceItems.put(serverInstanceId, groupItem);
        this.remoteServersListGroup.add((Widget)groupItem);
    }

    @Override
    public void setRulesCapability(boolean value) {
        this.ruleEnabled.setValue(Boolean.valueOf(value));
    }

    @Override
    public void setProcessCapability(boolean value) {
        this.processEnabled.setValue(Boolean.valueOf(value));
    }

    @Override
    public void setPlanningCapability(boolean value) {
        this.planningEnabled.setValue(Boolean.valueOf(value));
    }

    @Override
    public void confirmRemove(Command command) {
        YesNoCancelPopup result = YesNoCancelPopup.newYesNoCancelPopup((String)this.getTemplateRemovePopupTitle(), (String)this.getTemplateRemovePopupText(), (Command)command, (Command)new Command(){

            public void execute() {
            }
        }, null);
        result.clearScrollHeight();
        result.show();
    }

    @EventHandler(value={"add-new-container"})
    public void addNewContainer(ClickEvent event) {
        this.presenter.addNewContainer();
    }

    @EventHandler(value={"copy-current-server-template"})
    public void copyTemplate(ClickEvent event) {
        this.presenter.copyTemplate();
    }

    @EventHandler(value={"remove-current-server-template"})
    public void removeTemplate(ClickEvent event) {
        this.presenter.removeTemplate();
    }

    @Override
    public String getCopyTemplateErrorMessage() {
        return this.translationService.format("ServerTemplateView.CopyTemplateErrorMessage", new Object[0]);
    }

    @Override
    public String getRemoveTemplateErrorMessage() {
        return this.translationService.format("ServerTemplateView.RemoveTemplateErrorMessage", new Object[0]);
    }

    private String getRuleCheckBoxText() {
        return this.translationService.format("ServerTemplateView.RuleCheckBoxText", new Object[0]);
    }

    private String getProcessCheckBoxText() {
        return this.translationService.format("ServerTemplateView.ProcessCheckBoxText", new Object[0]);
    }

    private String getPlanningCheckBoxText() {
        return this.translationService.format("ServerTemplateView.PlanningCheckBoxText", new Object[0]);
    }

    private String getTemplateRemovePopupText() {
        return this.translationService.format("ServerTemplateView.TemplateRemovePopupText", new Object[0]);
    }

    private String getTemplateRemovePopupTitle() {
        return this.translationService.format("ServerTemplateView.TemplateRemovePopupTitle", new Object[0]);
    }
}

