/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.widget.card.body.notification;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.workbench.common.screens.server.management.client.widget.card.body.notification.NotificationType;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class NotificationPresenter {
    private final View view;

    @Inject
    public NotificationPresenter(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    public void setupOk() {
        this.view.setupOk();
    }

    public void setup(Message message) {
        PortablePreconditions.checkNotNull((String)"message", (Object)message);
        NotificationType notificationType = this.toNotificationType(message.getSeverity());
        if (notificationType.equals((Object)NotificationType.OK)) {
            this.view.setupOk();
        } else if (message.getMessages().isEmpty()) {
            this.view.setup(notificationType, "0");
        } else {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (String msg : message.getMessages()) {
                if (msg.trim().isEmpty()) continue;
                sb.append(++i).append(": ").append(msg).append('\n');
            }
            this.view.setup(notificationType, String.valueOf(i), this.clean(sb));
        }
    }

    private String clean(StringBuilder str) {
        String result = str.length() > 0 ? str.substring(0, str.length() - 1) : "";
        return result;
    }

    private NotificationType toNotificationType(Severity severity) {
        PortablePreconditions.checkNotNull((String)"severity", (Object)severity);
        switch (severity) {
            case WARN: {
                return NotificationType.WARNING;
            }
            case ERROR: {
                return NotificationType.ERROR;
            }
            case INFO: {
                return NotificationType.OK;
            }
        }
        return NotificationType.OK;
    }

    public static interface View
    extends IsWidget {
        public void setupOk();

        public void setup(NotificationType var1, String var2);

        public void setup(NotificationType var1, String var2, String var3);
    }
}

