/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.widget.config.process;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.workbench.common.screens.server.management.client.util.ClientMergeMode;
import org.kie.workbench.common.screens.server.management.client.util.ClientRuntimeStrategy;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class ProcessConfigPresenter {
    private final View view;
    private ContainerSpecKey containerSpecKey;
    private ProcessConfig processConfig;

    @Inject
    public ProcessConfigPresenter(View view) {
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void setup(ContainerSpecKey containerSpecKey, ProcessConfig processConfig) {
        this.processConfig = (ProcessConfig)PortablePreconditions.checkNotNull((String)"processConfig", (Object)processConfig);
        this.containerSpecKey = (ContainerSpecKey)PortablePreconditions.checkNotNull((String)"containerSpecKey", (Object)containerSpecKey);
        this.setupView(processConfig);
    }

    public void clear() {
        this.processConfig = null;
        this.containerSpecKey = null;
        this.view.clear();
    }

    public void setProcessConfig(ProcessConfig processConfig) {
        this.processConfig = processConfig;
        this.setupView(processConfig);
    }

    public ContainerSpecKey getContainerSpecKey() {
        return this.containerSpecKey;
    }

    public ProcessConfig getProcessConfig() {
        return this.processConfig;
    }

    private void setupView(ProcessConfig processConfig) {
        this.view.setContent(ClientRuntimeStrategy.convert(processConfig.getRuntimeStrategy(), this.view.getTranslationService()).getValue(this.view.getTranslationService()), processConfig.getKBase(), processConfig.getKSession(), ClientMergeMode.convert(processConfig.getMergeMode(), this.view.getTranslationService()).getValue(this.view.getTranslationService()));
    }

    public void disable() {
        this.view.disable();
    }

    public void cancel() {
        this.setupView(this.processConfig);
    }

    public ProcessConfig buildProcessConfig() {
        return new ProcessConfig(ClientRuntimeStrategy.convert(this.view.getRuntimeStrategy(), this.view.getTranslationService()).getRuntimeStrategy().toString(), this.view.getKBase(), this.view.getKSession(), ClientMergeMode.convert(this.view.getMergeMode(), this.view.getTranslationService()).getMergeMode().toString());
    }

    public List<String> getRuntimeStrategies() {
        return ClientRuntimeStrategy.listRuntimeStrategiesValues(this.view.getTranslationService());
    }

    public List<String> getMergeModes() {
        return ClientMergeMode.listMergeModeValues(this.view.getTranslationService());
    }

    public static interface View
    extends UberView<ProcessConfigPresenter> {
        public void setContent(String var1, String var2, String var3, String var4);

        public String getKBase();

        public String getKSession();

        public String getMergeMode();

        public String getRuntimeStrategy();

        public void disable();

        public void clear();

        public TranslationService getTranslationService();

        public String getConfigPageTitle();
    }
}

