/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.wizard;

import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.workbench.common.screens.server.management.client.events.ServerTemplateSelected;
import org.kie.workbench.common.screens.server.management.client.wizard.AbstractMultiPageWizard;
import org.kie.workbench.common.screens.server.management.client.wizard.config.process.ProcessConfigPagePresenter;
import org.kie.workbench.common.screens.server.management.client.wizard.container.NewContainerFormPresenter;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class NewContainerWizard
extends AbstractMultiPageWizard {
    private final NewContainerFormPresenter newContainerFormPresenter;
    private final ProcessConfigPagePresenter processConfigPagePresenter;
    private final Caller<SpecManagementService> specManagementService;
    private final Event<NotificationEvent> notification;
    private final Event<ServerTemplateSelected> serverTemplateSelectedEvent;
    private ServerTemplate serverTemplate;

    @Inject
    public NewContainerWizard(NewContainerFormPresenter newContainerFormPresenter, ProcessConfigPagePresenter processConfigPagePresenter, Caller<SpecManagementService> specManagementService, Event<NotificationEvent> notification, Event<ServerTemplateSelected> serverTemplateSelectedEvent) {
        this.newContainerFormPresenter = newContainerFormPresenter;
        this.processConfigPagePresenter = processConfigPagePresenter;
        this.specManagementService = specManagementService;
        this.notification = notification;
        this.serverTemplateSelectedEvent = serverTemplateSelectedEvent;
    }

    public void start() {
        this.newContainerFormPresenter.initialise();
        super.start();
    }

    public String getTitle() {
        return this.newContainerFormPresenter.getView().getNewContainerWizardTitle();
    }

    public int getPreferredHeight() {
        return 550;
    }

    public int getPreferredWidth() {
        return 800;
    }

    public void setServerTemplate(ServerTemplate serverTemplate) {
        this.serverTemplate = serverTemplate;
        this.newContainerFormPresenter.setServerTemplate(serverTemplate);
        this.pages.clear();
        this.pages.add(this.newContainerFormPresenter);
        if (serverTemplate.getCapabilities().contains(Capability.PROCESS.toString())) {
            this.pages.add(this.processConfigPagePresenter);
        }
    }

    public void clear() {
        this.newContainerFormPresenter.clear();
        this.processConfigPagePresenter.clear();
        this.pages.clear();
        this.pages.add(this.newContainerFormPresenter);
    }

    public void close() {
        super.close();
        this.clear();
    }

    public void complete() {
        HashMap<Capability, ContainerConfig> mapConfig = new HashMap<Capability, ContainerConfig>();
        if (this.getPages().size() == 2) {
            mapConfig.put(Capability.PROCESS, (ContainerConfig)this.processConfigPagePresenter.buildProcessConfig());
        }
        mapConfig.put(Capability.RULE, (ContainerConfig)new RuleConfig(null, KieScannerStatus.STOPPED));
        final ContainerSpec newContainer = this.newContainerFormPresenter.buildContainerSpec(this.newContainerFormPresenter.getServerTemplate().getId(), mapConfig);
        ((SpecManagementService)this.specManagementService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void o) {
                NewContainerWizard.this.notification.fire((Object)new NotificationEvent(NewContainerWizard.this.newContainerFormPresenter.getView().getNewContainerWizardSaveSuccess(), NotificationEvent.NotificationType.SUCCESS));
                NewContainerWizard.this.clear();
                NewContainerWizard.super.complete();
                NewContainerWizard.this.serverTemplateSelectedEvent.fire((Object)new ServerTemplateSelected((ServerTemplateKey)NewContainerWizard.this.serverTemplate, newContainer.getId()));
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                NewContainerWizard.this.notification.fire((Object)new NotificationEvent(NewContainerWizard.this.newContainerFormPresenter.getView().getNewContainerWizardSaveError(), NotificationEvent.NotificationType.ERROR));
                NewContainerWizard.this.pageSelected(0);
                NewContainerWizard.this.start();
                return false;
            }
        })).saveContainerSpec(this.newContainerFormPresenter.getServerTemplate().getId(), newContainer);
    }
}

