/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.screens.server.management.client.events.AddNewContainer;
import org.kie.workbench.common.screens.server.management.client.events.AddNewServerTemplate;
import org.kie.workbench.common.screens.server.management.client.wizard.NewContainerWizard;
import org.kie.workbench.common.screens.server.management.client.wizard.NewServerTemplateWizard;
import org.slf4j.Logger;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.annotations.WorkbenchPerspective;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@ApplicationScoped
@WorkbenchPerspective(identifier="ServerManagementPerspective")
public class ServerManagementPerspective {
    private final Logger logger;
    private final NewServerTemplateWizard newServerTemplateWizard;
    private final NewContainerWizard newContainerWizard;

    @Inject
    public ServerManagementPerspective(Logger logger, NewServerTemplateWizard newServerTemplateWizard, NewContainerWizard newContainerWizard) {
        this.logger = logger;
        this.newServerTemplateWizard = newServerTemplateWizard;
        this.newContainerWizard = newContainerWizard;
    }

    @Perspective
    public PerspectiveDefinition buildPerspective() {
        PerspectiveDefinitionImpl perspective = new PerspectiveDefinitionImpl(StaticWorkbenchPanelPresenter.class.getName());
        perspective.setName("ServerManagementPerspective");
        perspective.getRoot().addPart((PartDefinition)new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("ServerManagementBrowser")));
        return perspective;
    }

    public void onNewTemplate(@Observes AddNewServerTemplate addNewServerTemplate) {
        if (addNewServerTemplate != null) {
            this.newServerTemplateWizard.clear();
            this.newServerTemplateWizard.start();
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void onNewContainer(@Observes AddNewContainer addNewContainer) {
        if (addNewContainer != null && addNewContainer.getServerTemplate() != null) {
            this.newContainerWizard.clear();
            this.newContainerWizard.setServerTemplate(addNewContainer.getServerTemplate());
            this.newContainerWizard.start();
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }
}

