/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.container;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.workbench.common.screens.server.management.client.container.config.process.ContainerProcessConfigPresenter;
import org.kie.workbench.common.screens.server.management.client.container.config.rules.ContainerRulesConfigPresenter;
import org.kie.workbench.common.screens.server.management.client.container.status.ContainerRemoteStatusPresenter;
import org.kie.workbench.common.screens.server.management.client.container.status.empty.ContainerStatusEmptyPresenter;
import org.kie.workbench.common.screens.server.management.client.events.ContainerSpecSelected;
import org.kie.workbench.common.screens.server.management.client.events.RefreshRemoteServers;
import org.kie.workbench.common.screens.server.management.client.events.ServerTemplateSelected;
import org.kie.workbench.common.screens.server.management.client.util.State;
import org.kie.workbench.common.screens.server.management.model.ContainerSpecData;
import org.kie.workbench.common.screens.server.management.service.RuntimeManagementService;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.slf4j.Logger;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class ContainerPresenter {
    private final Logger logger;
    private final View view;
    private final ContainerRemoteStatusPresenter containerRemoteStatusPresenter;
    private final ContainerStatusEmptyPresenter containerStatusEmptyPresenter;
    private final ContainerProcessConfigPresenter containerProcessConfigPresenter;
    private final ContainerRulesConfigPresenter containerRulesConfigPresenter;
    private final Caller<RuntimeManagementService> runtimeManagementService;
    private final Caller<SpecManagementService> specManagementService;
    private final Event<ServerTemplateSelected> serverTemplateSelectedEvent;
    private final Event<NotificationEvent> notification;
    private ContainerSpec containerSpec;

    @Inject
    public ContainerPresenter(Logger logger, View view, ContainerRemoteStatusPresenter containerRemoteStatusPresenter, ContainerStatusEmptyPresenter containerStatusEmptyPresenter, ContainerProcessConfigPresenter containerProcessConfigPresenter, ContainerRulesConfigPresenter containerRulesConfigPresenter, Caller<RuntimeManagementService> runtimeManagementService, Caller<SpecManagementService> specManagementService, Event<ServerTemplateSelected> serverTemplateSelectedEvent, Event<NotificationEvent> notification) {
        this.logger = logger;
        this.view = view;
        this.containerRemoteStatusPresenter = containerRemoteStatusPresenter;
        this.containerStatusEmptyPresenter = containerStatusEmptyPresenter;
        this.containerProcessConfigPresenter = containerProcessConfigPresenter;
        this.containerRulesConfigPresenter = containerRulesConfigPresenter;
        this.runtimeManagementService = runtimeManagementService;
        this.specManagementService = specManagementService;
        this.serverTemplateSelectedEvent = serverTemplateSelectedEvent;
        this.notification = notification;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setStatus(this.containerRemoteStatusPresenter.getView());
        this.view.setRulesConfig(this.containerRulesConfigPresenter.getView());
        this.view.setProcessConfig(this.containerProcessConfigPresenter.getView());
    }

    public View getView() {
        return this.view;
    }

    public void onRefresh(@Observes RefreshRemoteServers refresh) {
        if (refresh != null && refresh.getContainerSpecKey() != null) {
            this.load(refresh.getContainerSpecKey());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void load(@Observes ContainerSpecSelected containerSpecSelected) {
        if (containerSpecSelected != null && containerSpecSelected.getContainerSpecKey() != null) {
            this.load(containerSpecSelected.getContainerSpecKey());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void loadContainers(@Observes ContainerSpecData content) {
        if (content != null && content.getContainerSpec() != null && content.getContainers() != null) {
            this.setup(content.getContainerSpec(), content.getContainers());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void refresh() {
        this.load((ContainerSpecKey)this.containerSpec);
    }

    public void load(ContainerSpecKey containerSpecKey) {
        PortablePreconditions.checkNotNull((String)"containerSpecKey", (Object)containerSpecKey);
        ((RuntimeManagementService)this.runtimeManagementService.call((RemoteCallback)new RemoteCallback<ContainerSpecData>(){

            public void callback(ContainerSpecData content) {
                PortablePreconditions.checkNotNull((String)"content", (Object)content);
                ContainerPresenter.this.setup(content.getContainerSpec(), content.getContainers());
            }
        })).getContainersByContainerSpec(containerSpecKey.getServerTemplateKey().getId(), containerSpecKey.getId());
    }

    private void setup(ContainerSpec containerSpec, Collection<Container> containers) {
        this.containerSpec = (ContainerSpec)PortablePreconditions.checkNotNull((String)"containerSpec", (Object)containerSpec);
        this.updateView(containers);
    }

    private void updateView(Collection<Container> containers) {
        this.containerStatusEmptyPresenter.setup((ContainerSpecKey)this.containerSpec);
        this.containerRemoteStatusPresenter.setup(this.containerSpec, containers);
        this.view.clear();
        if (this.isEmpty(containers)) {
            this.view.setStatus((IsWidget)this.containerStatusEmptyPresenter.getView());
        } else {
            this.view.setStatus(this.containerRemoteStatusPresenter.getView());
        }
        this.view.setContainerName(this.containerSpec.getContainerName());
        this.view.setGroupIp(this.containerSpec.getReleasedId().getGroupId());
        this.view.setArtifactId(this.containerSpec.getReleasedId().getArtifactId());
        this.containerRulesConfigPresenter.setVersion(this.containerSpec.getReleasedId().getVersion());
        this.containerProcessConfigPresenter.disable();
        this.updateStatus(this.containerSpec.getStatus() != null ? this.containerSpec.getStatus() : KieContainerStatus.STOPPED);
        for (Map.Entry entry : this.containerSpec.getConfigs().entrySet()) {
            switch ((Capability)entry.getKey()) {
                case RULE: {
                    this.setupRuleConfig((RuleConfig)entry.getValue());
                    break;
                }
                case PROCESS: {
                    this.setupProcessConfig((ProcessConfig)entry.getValue());
                }
            }
        }
    }

    private boolean isEmpty(Collection<Container> containers) {
        for (Container container : containers) {
            if (container.getStatus().equals((Object)KieContainerStatus.STOPPED)) continue;
            return false;
        }
        return true;
    }

    private void updateStatus(KieContainerStatus status) {
        switch (status) {
            case CREATING: 
            case STARTED: {
                this.view.disableRemoveButton();
                this.view.setContainerStartState(State.ENABLED);
                this.view.setContainerStopState(State.DISABLED);
                break;
            }
            case STOPPED: 
            case DISPOSING: 
            case FAILED: {
                this.view.enableRemoveButton();
                this.view.setContainerStartState(State.DISABLED);
                this.view.setContainerStopState(State.ENABLED);
            }
        }
    }

    private void setupProcessConfig(ProcessConfig value) {
        this.containerProcessConfigPresenter.setup((ContainerSpecKey)this.containerSpec, value);
    }

    private void setupRuleConfig(RuleConfig value) {
        this.containerRulesConfigPresenter.setup(this.containerSpec, value);
    }

    public void removeContainer() {
        this.view.confirmRemove(new Command(){

            public void execute() {
                ((SpecManagementService)ContainerPresenter.this.specManagementService.call((RemoteCallback)new RemoteCallback<Void>(){

                    public void callback(Void response) {
                        ContainerPresenter.this.notification.fire((Object)new NotificationEvent(ContainerPresenter.this.view.getRemoveContainerSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
                        ContainerPresenter.this.serverTemplateSelectedEvent.fire((Object)new ServerTemplateSelected(ContainerPresenter.this.containerSpec.getServerTemplateKey()));
                    }
                }, (ErrorCallback)new ErrorCallback<Object>(){

                    public boolean error(Object o, Throwable throwable) {
                        ContainerPresenter.this.notification.fire((Object)new NotificationEvent(ContainerPresenter.this.view.getRemoveContainerErrorMessage(), NotificationEvent.NotificationType.ERROR));
                        ContainerPresenter.this.serverTemplateSelectedEvent.fire((Object)new ServerTemplateSelected(ContainerPresenter.this.containerSpec.getServerTemplateKey()));
                        return false;
                    }
                })).deleteContainerSpec(ContainerPresenter.this.containerSpec.getServerTemplateKey().getId(), ContainerPresenter.this.containerSpec.getId());
            }
        });
    }

    public void stopContainer() {
        ((SpecManagementService)this.specManagementService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                ContainerPresenter.this.updateStatus(KieContainerStatus.STOPPED);
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                ContainerPresenter.this.notification.fire((Object)new NotificationEvent(ContainerPresenter.this.view.getStopContainerErrorMessage(), NotificationEvent.NotificationType.ERROR));
                ContainerPresenter.this.updateStatus(KieContainerStatus.STARTED);
                return false;
            }
        })).stopContainer((ContainerSpecKey)this.containerSpec);
    }

    public void startContainer() {
        ((SpecManagementService)this.specManagementService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                ContainerPresenter.this.updateStatus(KieContainerStatus.STARTED);
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                ContainerPresenter.this.notification.fire((Object)new NotificationEvent(ContainerPresenter.this.view.getStartContainerErrorMessage(), NotificationEvent.NotificationType.ERROR));
                ContainerPresenter.this.updateStatus(KieContainerStatus.STOPPED);
                return false;
            }
        })).startContainer((ContainerSpecKey)this.containerSpec);
    }

    public static interface View
    extends UberView<ContainerPresenter> {
        public void clear();

        public void disableRemoveButton();

        public void enableRemoveButton();

        public void setContainerName(String var1);

        public void setGroupIp(String var1);

        public void setArtifactId(String var1);

        public void setStatus(IsWidget var1);

        public void setProcessConfig(ContainerProcessConfigPresenter.View var1);

        public void setRulesConfig(ContainerRulesConfigPresenter.View var1);

        public void setContainerStopState(State var1);

        public void setContainerStartState(State var1);

        public void confirmRemove(Command var1);

        public String getRemoveContainerSuccessMessage();

        public String getRemoveContainerErrorMessage();

        public String getStopContainerErrorMessage();

        public String getStartContainerErrorMessage();
    }
}

