/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.container.config.process;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.workbench.common.screens.server.management.client.widget.config.process.ProcessConfigPresenter;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.uberfire.client.mvp.UberView;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class ContainerProcessConfigPresenter {
    private final View view;
    private final ProcessConfigPresenter processConfigPresenter;
    private final Caller<SpecManagementService> specManagementService;
    private final Event<NotificationEvent> notification;

    @Inject
    public ContainerProcessConfigPresenter(View view, ProcessConfigPresenter processConfigPresenter, Caller<SpecManagementService> specManagementService, Event<NotificationEvent> notification) {
        this.view = view;
        this.processConfigPresenter = processConfigPresenter;
        this.specManagementService = specManagementService;
        this.notification = notification;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setProcessConfigView(this.processConfigPresenter.getView());
    }

    public View getView() {
        return this.view;
    }

    public void setup(ContainerSpecKey containerSpecKey, ProcessConfig processConfig) {
        this.processConfigPresenter.setup(containerSpecKey, processConfig);
        this.setupView(processConfig);
    }

    private void setupView(ProcessConfig processConfig) {
        this.view.enableActions();
        this.processConfigPresenter.setProcessConfig(processConfig);
    }

    public void disable() {
        this.view.disable();
    }

    public void save() {
        this.view.disableActions();
        final ProcessConfig newProcessConfig = this.processConfigPresenter.buildProcessConfig();
        ((SpecManagementService)this.specManagementService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void containerConfig) {
                ContainerProcessConfigPresenter.this.notification.fire((Object)new NotificationEvent(ContainerProcessConfigPresenter.this.view.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
                ContainerProcessConfigPresenter.this.setupView(newProcessConfig);
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                ContainerProcessConfigPresenter.this.notification.fire((Object)new NotificationEvent(ContainerProcessConfigPresenter.this.view.getSaveErrorMessage(), NotificationEvent.NotificationType.ERROR));
                ContainerProcessConfigPresenter.this.setupView(ContainerProcessConfigPresenter.this.processConfigPresenter.getProcessConfig());
                return false;
            }
        })).updateContainerConfig(this.processConfigPresenter.getContainerSpecKey().getServerTemplateKey().getId(), this.processConfigPresenter.getContainerSpecKey().getId(), Capability.PROCESS, (ContainerConfig)newProcessConfig);
    }

    public void cancel() {
        this.setupView(this.processConfigPresenter.getProcessConfig());
    }

    public static interface View
    extends UberView<ContainerProcessConfigPresenter> {
        public void setProcessConfigView(ProcessConfigPresenter.View var1);

        public void disable();

        public void disableActions();

        public void enableActions();

        public String getSaveSuccessMessage();

        public String getSaveErrorMessage();
    }
}

