/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.navigation;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.LinkedGroup;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.server.management.client.navigation.ServerNavigationPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.CustomGroupItem;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ServerNavigationView
extends Composite
implements ServerNavigationPresenter.View {
    private ServerNavigationPresenter presenter;
    private TranslationService translationService;
    @DataField
    Element title = DOM.createElement((String)"strong");
    @Inject
    @DataField(value="new-server-template-button")
    Button newServerTemplate;
    @Inject
    @DataField(value="refresh-template-list-icon")
    Icon refresh;
    @Inject
    @DataField(value="template-server-list-group")
    LinkedGroup serverTemplates;
    private final Map<String, CustomGroupItem> idItem = new HashMap<String, CustomGroupItem>();
    private CustomGroupItem selected = null;

    @Inject
    public ServerNavigationView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(ServerNavigationPresenter presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void init() {
        this.title.setInnerText(this.getTitleText());
    }

    @EventHandler(value={"new-server-template-button"})
    public void addTemplate(ClickEvent event) {
        this.presenter.newTemplate();
    }

    @EventHandler(value={"refresh-template-list-icon"})
    public void refresh(ClickEvent event) {
        this.presenter.refresh();
    }

    @Override
    public void addTemplate(final String id, String name) {
        CustomGroupItem template = new CustomGroupItem(name, IconType.FOLDER_O, new Command(){

            public void execute() {
                ServerNavigationView.this.presenter.select(id);
            }
        });
        this.idItem.put(id, template);
        this.serverTemplates.add((Widget)template);
    }

    @Override
    public void select(String id) {
        if (this.selected != null) {
            this.selected.setActive(false);
            this.selected.removeStyleName("active");
        }
        this.selected = this.idItem.get(id);
        this.selected.setActive(true);
    }

    @Override
    public void clean() {
        this.serverTemplates.clear();
        this.selected = null;
        this.serverTemplates.clear();
    }

    private String getTitleText() {
        return this.translationService.format("ServerNavigationView.TitleText", new Object[0]);
    }
}

