/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.remote.card;

import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.workbench.common.screens.server.management.client.container.status.card.ContainerCardPresenter;
import org.kie.workbench.common.screens.server.management.client.events.ContainerSpecSelected;
import org.kie.workbench.common.screens.server.management.client.util.IOCUtil;
import org.kie.workbench.common.screens.server.management.client.widget.card.CardPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.body.BodyPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.footer.FooterPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.title.InfoTitlePresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.title.LinkTitlePresenter;
import org.uberfire.mvp.Command;

@Dependent
public class ContainerCardPresenter {
    private final IOCUtil iocUtil;
    private final ContainerCardPresenter.View view;
    private final Event<ContainerSpecSelected> containerSpecSelectedEvent;

    @Inject
    public ContainerCardPresenter(IOCUtil iocUtil, ContainerCardPresenter.View view, Event<ContainerSpecSelected> containerSpecSelectedEvent) {
        this.iocUtil = iocUtil;
        this.view = view;
        this.containerSpecSelectedEvent = containerSpecSelectedEvent;
    }

    public ContainerCardPresenter.View getView() {
        return this.view;
    }

    public void setup(final Container container) {
        LinkTitlePresenter linkTitlePresenter = this.iocUtil.newInstance(this, LinkTitlePresenter.class);
        linkTitlePresenter.setup(container.getContainerName(), new Command(){

            public void execute() {
                ContainerCardPresenter.this.containerSpecSelectedEvent.fire((Object)new ContainerSpecSelected(ContainerCardPresenter.this.buildContainerSpecKey(container)));
            }
        });
        InfoTitlePresenter infoTitlePresenter = this.iocUtil.newInstance(this, InfoTitlePresenter.class);
        infoTitlePresenter.setup(container.getResolvedReleasedId());
        BodyPresenter bodyPresenter = this.iocUtil.newInstance(this, BodyPresenter.class);
        bodyPresenter.setup(container.getMessages());
        FooterPresenter footerPresenter = this.iocUtil.newInstance(this, FooterPresenter.class);
        footerPresenter.setup(container.getUrl(), container.getResolvedReleasedId().getVersion());
        CardPresenter card = this.iocUtil.newInstance(this, CardPresenter.class);
        card.addTitle(linkTitlePresenter);
        card.addTitle(infoTitlePresenter);
        card.addBody(bodyPresenter);
        card.addFooter(footerPresenter);
        this.view.setCard(card.getView());
    }

    private ContainerSpecKey buildContainerSpecKey(Container container) {
        return new ContainerSpecKey(container.getContainerSpecId(), container.getContainerName(), new ServerTemplateKey(container.getServerInstanceKey().getServerTemplateId(), ""));
    }

    @PreDestroy
    public void destroy() {
        this.iocUtil.cleanup(this);
    }
}

