/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.util;

import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.server.management.model.RuntimeStrategy;

public enum ClientRuntimeStrategy {
    SINGLETON("ClientRuntimeStrategy.Singleton", RuntimeStrategy.SINGLETON),
    PER_REQUEST("ClientRuntimeStrategy.PerRequest", RuntimeStrategy.PER_REQUEST),
    PER_PROCESS_INSTANCE("ClientRuntimeStrategy.PerProcessInstance", RuntimeStrategy.PER_PROCESS_INSTANCE);

    private final String valueTranslationKey;
    private final RuntimeStrategy runtimeStrategy;

    private ClientRuntimeStrategy(String valueTranslationKey, RuntimeStrategy runtimeStrategy) {
        this.valueTranslationKey = valueTranslationKey;
        this.runtimeStrategy = runtimeStrategy;
    }

    public RuntimeStrategy getRuntimeStrategy() {
        return this.runtimeStrategy;
    }

    public String getValue(TranslationService translationService) {
        return translationService.format(this.valueTranslationKey, new Object[0]);
    }

    public static ClientRuntimeStrategy convert(RuntimeStrategy runtimeStrategy) {
        switch (runtimeStrategy) {
            case SINGLETON: {
                return SINGLETON;
            }
            case PER_REQUEST: {
                return PER_REQUEST;
            }
            case PER_PROCESS_INSTANCE: {
                return PER_PROCESS_INSTANCE;
            }
        }
        throw new RuntimeException("Invalid parameter");
    }

    public static ClientRuntimeStrategy convert(String runtimeStrategy, TranslationService translationService) {
        for (ClientRuntimeStrategy clientRuntimeStrategy : ClientRuntimeStrategy.values()) {
            if (!runtimeStrategy.equals(clientRuntimeStrategy.getValue(translationService))) continue;
            return clientRuntimeStrategy;
        }
        return SINGLETON;
    }

    public static List<String> listRuntimeStrategiesValues(TranslationService translationService) {
        ArrayList<String> runtimeStrategyValues = new ArrayList<String>();
        for (ClientRuntimeStrategy clientRuntimeStrategy : ClientRuntimeStrategy.values()) {
            runtimeStrategyValues.add(clientRuntimeStrategy.getValue(translationService));
        }
        return runtimeStrategyValues;
    }
}

