/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.widget.artifact;

import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.m2repo.client.widgets.ArtifactListPresenter;
import org.guvnor.m2repo.client.widgets.ArtifactListView;
import org.guvnor.m2repo.client.widgets.ColumnType;
import org.kie.workbench.common.screens.server.management.client.events.DependencyPathSelectedEvent;
import org.uberfire.client.mvp.UberView;

@Dependent
public class ArtifactListWidgetPresenter {
    private final View view;
    private final List<String> FORMATS = Arrays.asList("*.jar");
    private final ArtifactListPresenter artifactListPresenter;
    private final Event<DependencyPathSelectedEvent> dependencyPathSelectedEvent;

    @Inject
    public ArtifactListWidgetPresenter(View view, ArtifactListPresenter artifactListPresenter, Event<DependencyPathSelectedEvent> dependencyPathSelectedEvent) {
        this.view = view;
        this.artifactListPresenter = artifactListPresenter;
        this.dependencyPathSelectedEvent = dependencyPathSelectedEvent;
    }

    @PostConstruct
    public void init() {
        this.artifactListPresenter.notifyOnRefresh(false);
        this.artifactListPresenter.setup(new ColumnType[]{ColumnType.GAV});
        this.view.init(this);
        this.artifactListPresenter.search("");
    }

    public View getView() {
        return this.view;
    }

    public void search(String value) {
        this.artifactListPresenter.search(value, this.FORMATS);
    }

    public void clear() {
        this.view.clear();
        this.search("");
    }

    public ArtifactListView getArtifactListView() {
        return this.artifactListPresenter.getView();
    }

    public void onSelect(String pathSelected) {
        this.dependencyPathSelectedEvent.fire((Object)new DependencyPathSelectedEvent(this, pathSelected));
    }

    public void refresh() {
        this.artifactListPresenter.refresh();
    }

    public static interface View
    extends UberView<ArtifactListWidgetPresenter> {
        public void clear();
    }
}

