/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.wizard.template;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.server.management.client.util.ContentChangeHandler;
import org.kie.workbench.common.screens.server.management.client.wizard.template.NewTemplatePresenter;
import org.uberfire.ext.widgets.common.client.common.StyleHelper;

@Dependent
@Templated
public class NewTemplateView
extends Composite
implements NewTemplatePresenter.View {
    private NewTemplatePresenter presenter;
    private TranslationService translationService;
    @DataField(value="new-template-name-form")
    Element templateNameGroup = DOM.createDiv();
    @Inject
    @DataField(value="new-template-name-textbox")
    TextBox templateName;
    @DataField(value="new-template-name-help")
    Element templateNameHelp = DOM.createSpan();
    @DataField(value="capability-checkbox-form")
    Element capabilityGroup = DOM.createDiv();
    @Inject
    @DataField(value="new-rule-capability-checkbox")
    CheckBox ruleEnabled;
    @Inject
    @DataField(value="new-process-capability-checkbox")
    CheckBox processEnabled;
    @Inject
    @DataField(value="new-planning-capability-checkbox")
    CheckBox planningEnabled;
    private final ArrayList<ContentChangeHandler> changeHandlers = new ArrayList();

    @Inject
    public NewTemplateView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(final NewTemplatePresenter presenter) {
        this.presenter = presenter;
        this.ruleEnabled.setText(this.getRuleCheckBoxText());
        this.processEnabled.setText(this.getProcessCheckBoxText());
        this.planningEnabled.setText(this.getPlanningCheckBoxText());
        this.templateName.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (presenter.isTemplateNameValid()) {
                    NewTemplateView.this.noErrorOnTemplateName();
                } else {
                    NewTemplateView.this.errorOnTemplateName();
                }
                NewTemplateView.this.fireChangeHandlers();
            }
        });
        this.ruleEnabled.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewTemplateView.this.fireChangeHandlers();
            }
        });
        this.processEnabled.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewTemplateView.this.fireChangeHandlers();
            }
        });
        this.planningEnabled.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (NewTemplateView.this.planningEnabled.getValue().booleanValue()) {
                    NewTemplateView.this.ruleEnabled.setValue(Boolean.valueOf(true));
                }
                NewTemplateView.this.fireChangeHandlers();
            }
        });
        this.processEnabled.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewTemplateView.this.fireChangeHandlers();
            }
        });
    }

    private void fireChangeHandlers() {
        for (ContentChangeHandler changeHandler : this.changeHandlers) {
            changeHandler.onContentChange();
        }
    }

    @Override
    public String getTitle() {
        return this.getTitleText();
    }

    @Override
    public void clear() {
        this.templateName.setText("");
        this.ruleEnabled.setValue(Boolean.valueOf(false));
        this.processEnabled.setValue(Boolean.valueOf(false));
        this.planningEnabled.setValue(Boolean.valueOf(false));
        this.noErrors();
    }

    @Override
    public void addContentChangeHandler(ContentChangeHandler contentChangeHandler) {
        this.changeHandlers.add(contentChangeHandler);
    }

    @Override
    public boolean getProcessCapabilityCheck() {
        return this.processEnabled.getValue();
    }

    @Override
    public String getTemplateName() {
        return this.templateName.getText();
    }

    @Override
    public boolean isRuleCapabilityChecked() {
        return this.ruleEnabled.getValue();
    }

    @Override
    public boolean isProcessCapabilityChecked() {
        return this.processEnabled.getValue();
    }

    @Override
    public boolean isPlanningCapabilityChecked() {
        return this.planningEnabled.getValue();
    }

    @Override
    public void errorOnTemplateName() {
        StyleHelper.addUniqueEnumStyleName((Element)this.templateNameGroup, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
    }

    @Override
    public void errorOnTemplateName(String message) {
        this.errorOnTemplateName();
        this.templateNameHelp.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.templateNameHelp.setInnerText(message);
    }

    @Override
    public void noErrorOnTemplateName() {
        this.templateNameHelp.getStyle().setVisibility(Style.Visibility.HIDDEN);
        StyleHelper.addUniqueEnumStyleName((Element)this.templateNameGroup, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
    }

    @Override
    public void errorCapability() {
        StyleHelper.addUniqueEnumStyleName((Element)this.capabilityGroup, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
    }

    @Override
    public void noErrorOnCapability() {
        StyleHelper.addUniqueEnumStyleName((Element)this.capabilityGroup, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
    }

    @Override
    public void noErrors() {
        this.noErrorOnTemplateName();
        this.noErrorOnCapability();
    }

    @Override
    public String getInvalidErrorMessage() {
        return this.translationService.format("NewTemplateView.InvalidErrorMessage", new Object[0]);
    }

    @Override
    public String getNewServerTemplateWizardTitle() {
        return this.translationService.format("NewTemplateView.NewServerTemplateWizardTitle", new Object[0]);
    }

    @Override
    public String getNewServerTemplateWizardSaveSuccess() {
        return this.translationService.format("NewTemplateView.NewServerTemplateWizardSaveSuccess", new Object[0]);
    }

    @Override
    public String getNewServerTemplateWizardSaveError() {
        return this.translationService.format("NewTemplateView.NewServerTemplateWizardSaveError", new Object[0]);
    }

    private String getRuleCheckBoxText() {
        return this.translationService.format("NewTemplateView.RuleCheckBoxText", new Object[0]);
    }

    private String getProcessCheckBoxText() {
        return this.translationService.format("NewTemplateView.ProcessCheckBoxText", new Object[0]);
    }

    private String getPlanningCheckBoxText() {
        return this.translationService.format("NewTemplateView.PlanningCheckBoxText", new Object[0]);
    }

    private String getTitleText() {
        return this.translationService.format("NewTemplateView.TitleText", new Object[0]);
    }
}

