/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.workbench.common.screens.server.management.client.container.ContainerPresenter;
import org.kie.workbench.common.screens.server.management.client.container.empty.ServerContainerEmptyPresenter;
import org.kie.workbench.common.screens.server.management.client.empty.ServerEmptyPresenter;
import org.kie.workbench.common.screens.server.management.client.events.ContainerSpecSelected;
import org.kie.workbench.common.screens.server.management.client.events.ServerInstanceSelected;
import org.kie.workbench.common.screens.server.management.client.events.ServerTemplateListRefresh;
import org.kie.workbench.common.screens.server.management.client.events.ServerTemplateSelected;
import org.kie.workbench.common.screens.server.management.client.navigation.ServerNavigationPresenter;
import org.kie.workbench.common.screens.server.management.client.navigation.template.ServerTemplatePresenter;
import org.kie.workbench.common.screens.server.management.client.remote.RemotePresenter;
import org.kie.workbench.common.screens.server.management.client.util.ClientContainerRuntimeOperation;
import org.kie.workbench.common.screens.server.management.model.ContainerUpdateEvent;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.slf4j.Logger;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
@WorkbenchScreen(identifier="ServerManagementBrowser")
public class ServerManagementBrowserPresenter {
    private final Logger logger;
    private final View view;
    private final ServerNavigationPresenter navigationPresenter;
    private final ServerTemplatePresenter serverTemplatePresenter;
    private final ServerEmptyPresenter serverEmptyPresenter;
    private final ServerContainerEmptyPresenter serverContainerEmptyPresenter;
    private final ContainerPresenter containerPresenter;
    private final RemotePresenter remotePresenter;
    private final Caller<SpecManagementService> specManagementService;
    private final Event<ServerTemplateSelected> serverTemplateSelectedEvent;
    private final Event<NotificationEvent> notification;
    private boolean isEmpty = true;

    @Inject
    public ServerManagementBrowserPresenter(Logger logger, View view, ServerNavigationPresenter navigationPresenter, ServerTemplatePresenter serverTemplatePresenter, ServerEmptyPresenter serverEmptyPresenter, ServerContainerEmptyPresenter serverContainerEmptyPresenter, ContainerPresenter containerPresenter, RemotePresenter remotePresenter, Caller<SpecManagementService> specManagementService, Event<ServerTemplateSelected> serverTemplateSelectedEvent, Event<NotificationEvent> notification) {
        this.logger = logger;
        this.view = view;
        this.navigationPresenter = navigationPresenter;
        this.serverTemplatePresenter = serverTemplatePresenter;
        this.serverEmptyPresenter = serverEmptyPresenter;
        this.serverContainerEmptyPresenter = serverContainerEmptyPresenter;
        this.containerPresenter = containerPresenter;
        this.remotePresenter = remotePresenter;
        this.specManagementService = specManagementService;
        this.serverTemplateSelectedEvent = serverTemplateSelectedEvent;
        this.notification = notification;
    }

    @PostConstruct
    public void init() {
        this.view.setNavigation(this.navigationPresenter.getView());
    }

    @OnOpen
    public void onOpen() {
        this.refreshList(new ServerTemplateListRefresh());
    }

    public void onServerDeleted(@Observes ServerTemplateDeleted serverTemplateDeleted) {
        if (serverTemplateDeleted != null) {
            this.refreshList(new ServerTemplateListRefresh());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    private void refreshList(final @Observes ServerTemplateListRefresh refresh) {
        ((SpecManagementService)this.specManagementService.call((RemoteCallback)new RemoteCallback<Collection<ServerTemplateKey>>(){

            public void callback(Collection<ServerTemplateKey> serverTemplateKeys) {
                ServerManagementBrowserPresenter.this.setup(serverTemplateKeys, refresh.getSelectServerTemplateId());
            }
        })).listServerTemplateKeys();
    }

    public void onSelected(@Observes ServerTemplateSelected serverTemplateSelected) {
        if (serverTemplateSelected != null && serverTemplateSelected.getServerTemplateKey() != null && serverTemplateSelected.getServerTemplateKey().getId() != null) {
            this.selectServerTemplate(serverTemplateSelected.getServerTemplateKey().getId(), serverTemplateSelected.getContainerId());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    private void selectServerTemplate(String serverTemplateId, final String containerId) {
        ((SpecManagementService)this.specManagementService.call((RemoteCallback)new RemoteCallback<ServerTemplate>(){

            public void callback(ServerTemplate serverTemplate) {
                ServerManagementBrowserPresenter.this.setup(serverTemplate, containerId);
            }
        })).getServerTemplate(serverTemplateId);
    }

    public void onSelected(@Observes ContainerSpecSelected containerSpecSelected) {
        if (containerSpecSelected != null && containerSpecSelected.getContainerSpecKey() != null) {
            this.view.setContent((IsWidget)this.containerPresenter.getView());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void onSelected(@Observes ServerInstanceSelected serverInstanceSelected) {
        if (serverInstanceSelected != null && serverInstanceSelected.getServerInstanceKey() != null) {
            this.view.setContent((IsWidget)this.remotePresenter.getView());
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void onContainerUpdate(@Observes ContainerUpdateEvent containerUpdateEvent) {
        if (containerUpdateEvent != null && containerUpdateEvent.getContainerRuntimeOperation() != null && containerUpdateEvent.getContainerRuntimeState() != null && containerUpdateEvent.getFailedServerInstances().size() > 0) {
            NotificationEvent.NotificationType notificationType;
            String message;
            ClientContainerRuntimeOperation containerRuntimeOperation = ClientContainerRuntimeOperation.convert(containerUpdateEvent.getContainerRuntimeOperation());
            switch (containerUpdateEvent.getContainerRuntimeState()) {
                case OFFLINE: {
                    message = this.view.getErrorMessage(containerRuntimeOperation, containerUpdateEvent.getFailedServerInstances().size());
                    notificationType = NotificationEvent.NotificationType.ERROR;
                    break;
                }
                case PARTIAL_ONLINE: {
                    message = this.view.getWarnMessage(containerRuntimeOperation, containerUpdateEvent.getFailedServerInstances().size());
                    notificationType = NotificationEvent.NotificationType.WARNING;
                    break;
                }
                case ONLINE: {
                    message = this.view.getSuccessMessage(containerRuntimeOperation, containerUpdateEvent.getFailedServerInstances().size());
                    notificationType = NotificationEvent.NotificationType.SUCCESS;
                    break;
                }
                default: {
                    message = null;
                    notificationType = null;
                }
            }
            if (message != null) {
                this.notification.fire((Object)new NotificationEvent(message, notificationType));
            }
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void setup(Collection<ServerTemplateKey> serverTemplateKeys, String selectServerTemplateId) {
        if (serverTemplateKeys.isEmpty()) {
            this.isEmpty = true;
            this.view.setEmptyView(this.serverEmptyPresenter.getView());
            this.navigationPresenter.clear();
        } else {
            this.isEmpty = false;
            ServerTemplateKey serverTemplate2BeSelected = null;
            if (selectServerTemplateId != null) {
                for (ServerTemplateKey serverTemplateKey : serverTemplateKeys) {
                    if (!serverTemplateKey.getId().equals(selectServerTemplateId)) continue;
                    serverTemplate2BeSelected = serverTemplateKey;
                    break;
                }
            }
            if (serverTemplate2BeSelected == null) {
                serverTemplate2BeSelected = serverTemplateKeys.iterator().next();
            }
            this.navigationPresenter.setup(serverTemplate2BeSelected, serverTemplateKeys);
            this.serverTemplateSelectedEvent.fire((Object)new ServerTemplateSelected(serverTemplate2BeSelected));
        }
    }

    public void onServerTemplateUpdated(@Observes ServerTemplateUpdated serverTemplateUpdated) {
        if (serverTemplateUpdated != null && serverTemplateUpdated.getServerTemplate() != null) {
            final ServerTemplate serverTemplate = serverTemplateUpdated.getServerTemplate();
            if (this.isEmpty) {
                this.setup((Collection<ServerTemplateKey>)new ArrayList<ServerTemplateKey>(){
                    {
                        this.add(serverTemplate);
                    }
                }, serverTemplate.getId());
            }
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void onDelete(@Observes ServerInstanceDeleted serverInstanceDeleted) {
        if (serverInstanceDeleted != null && serverInstanceDeleted.getServerInstanceId() != null && this.serverTemplatePresenter.getCurrentServerTemplate() != null) {
            String deletedServerInstanceId = serverInstanceDeleted.getServerInstanceId();
            for (ServerInstanceKey serverInstanceKey : this.serverTemplatePresenter.getCurrentServerTemplate().getServerInstanceKeys()) {
                if (!deletedServerInstanceId.equals(serverInstanceKey.getServerInstanceId())) continue;
                this.refreshList(new ServerTemplateListRefresh(this.serverTemplatePresenter.getCurrentServerTemplate().getId()));
                break;
            }
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    private void setup(ServerTemplate serverTemplate, String selectContainerId) {
        this.view.setServerTemplate(this.serverTemplatePresenter.getView());
        ContainerSpec firstContainerSpec = null;
        if (serverTemplate.getContainersSpec().isEmpty()) {
            this.serverContainerEmptyPresenter.setTemplate(serverTemplate);
            this.view.setContent((IsWidget)this.serverContainerEmptyPresenter.getView());
            firstContainerSpec = null;
        } else {
            if (selectContainerId != null) {
                for (ContainerSpec containerSpec : serverTemplate.getContainersSpec()) {
                    if (!containerSpec.getId().equals(selectContainerId)) continue;
                    firstContainerSpec = containerSpec;
                    break;
                }
            }
            if (firstContainerSpec == null) {
                firstContainerSpec = (ContainerSpec)serverTemplate.getContainersSpec().iterator().next();
            }
        }
        this.serverTemplatePresenter.setup(serverTemplate, firstContainerSpec);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Server Management Browser";
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.view;
    }

    public static interface View
    extends IsWidget {
        public void setNavigation(ServerNavigationPresenter.View var1);

        public void setServerTemplate(ServerTemplatePresenter.View var1);

        public void setEmptyView(ServerEmptyPresenter.View var1);

        public void setContent(IsWidget var1);

        public String getSuccessMessage(ClientContainerRuntimeOperation var1, int var2);

        public String getErrorMessage(ClientContainerRuntimeOperation var1, int var2);

        public String getWarnMessage(ClientContainerRuntimeOperation var1, int var2);
    }
}

