/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.container.config.rules;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.server.management.client.container.config.rules.ContainerRulesConfigPresenter;
import org.kie.workbench.common.screens.server.management.client.util.State;
import org.kie.workbench.common.screens.server.management.client.widget.NumericTextBox;
import org.uberfire.ext.widgets.common.client.common.StyleHelper;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ContainerRulesConfigView
extends Composite
implements ContainerRulesConfigPresenter.View {
    private ContainerRulesConfigPresenter presenter;
    private TranslationService translationService;
    @DataField(value="container-config-alert-span")
    Element alert = DOM.createSpan();
    @DataField(value="container-config-scanner-form")
    Element scannerForm = DOM.createDiv();
    @DataField(value="container-config-scanner-label")
    Element scannerLabel = DOM.createLabel();
    @Inject
    @DataField(value="container-config-interval-textbox")
    NumericTextBox interval;
    @Inject
    @DataField(value="container-config-stop-scanner")
    Button stopScanner;
    @Inject
    @DataField(value="container-config-start-scanner")
    Button startScanner;
    @Inject
    @DataField(value="container-config-scan-now")
    Button scanNow;
    @DataField(value="container-config-version-form")
    Element versionForm = DOM.createDiv();
    @DataField(value="container-config-version-label")
    Element versionLabel = DOM.createLabel();
    @Inject
    @DataField(value="container-config-version-textbox")
    TextBox version;
    @Inject
    @DataField(value="container-config-upgrade-button")
    Button upgrade;
    private Command stopScannerActive = new Command(){

        public void execute() {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new com.google.gwt.user.client.Command(){

                public void execute() {
                    ContainerRulesConfigView.this.stopScanner.setActive(true);
                    ContainerRulesConfigView.this.startScanner.setActive(false);
                }
            });
        }
    };

    @Inject
    public ContainerRulesConfigView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(ContainerRulesConfigPresenter presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void init() {
        this.version.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (!ContainerRulesConfigView.this.version.getText().trim().isEmpty()) {
                    StyleHelper.addUniqueEnumStyleName((Element)ContainerRulesConfigView.this.versionForm, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
                }
            }
        });
        this.version.getElement().setAttribute("placeholder", this.getVersionTextBoxPlaceholder());
        this.interval.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (!ContainerRulesConfigView.this.interval.getText().trim().isEmpty()) {
                    StyleHelper.addUniqueEnumStyleName((Element)ContainerRulesConfigView.this.scannerForm, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
                }
            }
        });
        this.interval.getElement().setAttribute("placeholder", this.getIntervalTextBoxPlaceholder());
        this.interval.getElement().setAttribute("data-original-title", this.getIntervalTextBoxDataOriginalTitle());
    }

    @Override
    public void setContent(String interval, String version, State startScanner, State stopScanner, State scanNow, State upgrade) {
        StyleHelper.addUniqueEnumStyleName((Element)this.scannerForm, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
        StyleHelper.addUniqueEnumStyleName((Element)this.versionForm, ValidationState.class, (Style.HasCssName)ValidationState.NONE);
        if (interval == null || interval.trim().isEmpty()) {
            this.interval.setText("");
        } else {
            try {
                this.interval.setText(Integer.valueOf(interval).toString());
            }
            catch (NumberFormatException ex) {
                this.interval.setText("");
            }
        }
        this.version.setText(version != null ? version : "");
        this.interval.setText(interval);
        this.setStartScannerState(startScanner);
        this.setStopScannerState(stopScanner);
        this.setScanNowState(scanNow);
        this.setUpgradeState(upgrade);
    }

    @Override
    public void setStartScannerState(State state) {
        this.startScanner.setEnabled(state.equals((Object)State.ENABLED));
        this.startScanner.setActive(!state.equals((Object)State.ENABLED));
    }

    @Override
    public void setStopScannerState(State state) {
        this.stopScanner.setEnabled(state.equals((Object)State.ENABLED));
        this.stopScanner.setActive(!state.equals((Object)State.ENABLED));
    }

    @Override
    public void setScanNowState(State state) {
        this.scanNow.setEnabled(state.equals((Object)State.ENABLED));
    }

    @Override
    public void setUpgradeState(State state) {
        this.upgrade.setEnabled(state.equals((Object)State.ENABLED));
    }

    @Override
    public void disableActions() {
        this.startScanner.setEnabled(false);
        this.scanNow.setEnabled(false);
        this.stopScanner.setEnabled(false);
        this.upgrade.setEnabled(false);
    }

    @Override
    public void errorOnInterval() {
        this.startScanner.setEnabled(true);
        this.startScanner.setActive(false);
        StyleHelper.addUniqueEnumStyleName((Element)this.scannerForm, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
        this.interval.setFocus(true);
    }

    @Override
    public String getInterval() {
        return this.interval.getText();
    }

    @Override
    public String getVersion() {
        return this.version.getText();
    }

    @Override
    public void setVersion(String version) {
        this.version.setText(version);
    }

    @EventHandler(value={"container-config-start-scanner"})
    public void startScanner(ClickEvent event) {
        if (this.startScanner.isActive()) {
            return;
        }
        try {
            this.presenter.startScanner(this.getInterval());
        }
        catch (IllegalArgumentException ex) {
            StyleHelper.addUniqueEnumStyleName((Element)this.scannerForm, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
            this.stopScannerActive.execute();
        }
    }

    @EventHandler(value={"container-config-stop-scanner"})
    public void stopScanner(ClickEvent e) {
        if (this.stopScanner.isActive()) {
            return;
        }
        this.stopScannerActive.execute();
        this.presenter.stopScanner();
    }

    @EventHandler(value={"container-config-scan-now"})
    public void scanNow(ClickEvent e) {
        this.stopScannerActive.execute();
        this.presenter.scanNow();
    }

    @EventHandler(value={"container-config-upgrade-button"})
    public void upgrade(ClickEvent e) {
        try {
            this.presenter.upgrade(this.version.getText());
        }
        catch (IllegalArgumentException ex) {
            StyleHelper.addUniqueEnumStyleName((Element)this.versionForm, ValidationState.class, (Style.HasCssName)ValidationState.ERROR);
        }
    }

    @Override
    public String getStartScannerErrorMessage() {
        return this.translationService.format("ContainerRulesConfigView.StartScannerErrorMessage", new Object[0]);
    }

    @Override
    public String getStopScannerErrorMessage() {
        return this.translationService.format("ContainerRulesConfigView.StopScannerErrorMessage", new Object[0]);
    }

    @Override
    public String getScanNowErrorMessage() {
        return this.translationService.format("ContainerRulesConfigView.ScanNowErrorMessage", new Object[0]);
    }

    @Override
    public String getUpgradeErrorMessage() {
        return this.translationService.format("ContainerRulesConfigView.UpgradeErrorMessage", new Object[0]);
    }

    @Override
    public String getUpgradeSuccessMessage() {
        return this.translationService.format("ContainerRulesConfigView.UpgradeSuccessMessage", new Object[]{this.version.getText()});
    }

    private String getVersionTextBoxPlaceholder() {
        return this.translationService.format("ContainerRulesConfigView.VersionTextBoxPlaceholder", new Object[0]);
    }

    private String getIntervalTextBoxPlaceholder() {
        return this.translationService.format("ContainerRulesConfigView.IntervalTextBoxPlaceholder", new Object[0]);
    }

    private String getIntervalTextBoxDataOriginalTitle() {
        return this.translationService.format("ContainerRulesConfigView.IntervalTextBoxDataOriginalTitle", new Object[0]);
    }
}

